/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.core.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.omegablacksmith.core.registries.CapabilityRegistry;
import ru.justagod.cutter.invoke.Invoke;

public record SetMultiplierPacket(float multiplier) {
    public static void encode(SetMultiplierPacket msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.multiplier());
    }

    public static SetMultiplierPacket decode(FriendlyByteBuf buf) {
        return new SetMultiplierPacket(buf.readFloat());
    }

    public static void handle(SetMultiplierPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Invoke.server(() -> SetMultiplierPacket.lambda$handle$1((Supplier)ctx, msg)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Supplier ctx, SetMultiplierPacket msg) {
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        if (player == null) {
            return;
        }
        player.getCapability(CapabilityRegistry.REFORGE_MULTIPLIER_CAPABILITY).ifPresent(cap -> cap.setMultiplier(msg.multiplier()));
    }
}

