/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.core.reforge;

import com.idark.valoria.registries.AttributeReg;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import ru.auriny.omegablacksmith.core.reforge.ReforgeType;
import ru.auriny.omegablacksmith.core.registries.AttributeRegistry;

public final class ReforgeRegistry {
    private static final Map<String, ReforgeType> REGISTRY = new LinkedHashMap<String, ReforgeType>();
    public static final ReforgeType LIGHTNING = ReforgeRegistry.register(new ReforgeType.Builder("lightning").displayName("\u041c\u043e\u043b\u043d\u0438\u0435\u043d\u043e\u0441\u043d\u044b\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, Attributes.f_22283_, 0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, 0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(3, Attributes.f_22281_, 1000.0, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType SCORNFUL = ReforgeRegistry.register(new ReforgeType.Builder("scornful").displayName("\u041f\u0440\u0435\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), 0.2, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), 0.4, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType SHARPENED = ReforgeRegistry.register(new ReforgeType.Builder("sharpened").displayName("\u0417\u0430\u0442\u043e\u0447\u0435\u043d\u043d\u044b\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, Attributes.f_22281_, 0.045, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, 0.09, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType DEMONIC = ReforgeRegistry.register(new ReforgeType.Builder("demonic").displayName("\u0414\u0435\u043c\u043e\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, Attributes.f_22281_, 0.6, AttributeModifier.Operation.ADDITION).modifier(1, Attributes.f_22283_, 0.1, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22281_, 1.2, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22283_, 0.2, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType POWERFUL = ReforgeRegistry.register(new ReforgeType.Builder("powerful").displayName("\u041c\u043e\u0449\u043d\u044b\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, Attributes.f_22281_, 0.03, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22282_, 0.3, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22281_, 0.06, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22282_, 0.6, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType FEROCIOUS = ReforgeRegistry.register(new ReforgeType.Builder("ferocious").displayName("\u0421\u0432\u0438\u0440\u0435\u043f\u044b\u0439").category(ReforgeType.Category.POSITIVE).modifier(1, Attributes.f_22281_, 0.03, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22283_, 0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, 0.06, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, 0.1, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType SHORTENED = ReforgeRegistry.register(new ReforgeType.Builder("shortened").displayName("\u0423\u043a\u043e\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22283_, 0.075, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, 0.15, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.1, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType RUTHLESS = ReforgeRegistry.register(new ReforgeType.Builder("ruthless").displayName("\u0411\u0435\u0437\u0436\u0430\u043b\u043e\u0441\u0442\u043d\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22281_, 0.065, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22282_, -0.18, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, 0.13, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22282_, -0.36, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType MAJESTIC = ReforgeRegistry.register(new ReforgeType.Builder("majestic").displayName("\u0412\u0435\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22281_, 1.0, AttributeModifier.Operation.ADDITION).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), 0.125, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22283_, -0.08, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, 2.0, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, -0.16, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType UNBALANCED = ReforgeRegistry.register(new ReforgeType.Builder("unbalanced").displayName("\u0420\u0430\u0437\u0431\u0430\u043b\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22282_, 0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22281_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22282_, 0.2, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, -0.2, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType HEAVY = ReforgeRegistry.register(new ReforgeType.Builder("heavy").displayName("\u0422\u044f\u0436\u0451\u043b\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22281_, 0.5, AttributeModifier.Operation.ADDITION).modifier(1, Attributes.f_22282_, 0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22283_, -0.03, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, 1.0, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22282_, 0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, -0.06, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType WEIGHTLESS = ReforgeRegistry.register(new ReforgeType.Builder("weightless").displayName("\u041d\u0435\u0432\u0435\u0441\u043e\u043c\u044b\u0439").category(ReforgeType.Category.NEUTRAL).modifier(1, Attributes.f_22283_, 0.08, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22282_, -0.15, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, 0.16, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22282_, -0.3, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType BLUNTED = ReforgeRegistry.register(new ReforgeType.Builder("blunted").displayName("\u0417\u0430\u0442\u0443\u043f\u043b\u0435\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22281_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType AWKWARD = ReforgeRegistry.register(new ReforgeType.Builder("awkward").displayName("\u041d\u0435\u043b\u043e\u0432\u043a\u0438\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, (Attribute)AttributeReg.MISS_CHANCE.get(), 5.0, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)AttributeReg.MISS_CHANCE.get(), 10.0, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType BROKEN = ReforgeRegistry.register(new ReforgeType.Builder("broken").displayName("\u0421\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, (Attribute)AttributeReg.MISS_CHANCE.get(), 5.0, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)AttributeReg.MISS_CHANCE.get(), 10.0, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType SHORT = ReforgeRegistry.register(new ReforgeType.Builder("short").displayName("\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.2, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.4, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType WEAK = ReforgeRegistry.register(new ReforgeType.Builder("weak").displayName("\u0421\u043b\u0430\u0431\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22281_, -0.5, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22281_, -1.0, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType SLOW = ReforgeRegistry.register(new ReforgeType.Builder("slow").displayName("\u041c\u0435\u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22283_, -0.075, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22283_, -0.15, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType SHATTERED = ReforgeRegistry.register(new ReforgeType.Builder("shattered").displayName("\u0422\u0440\u0435\u0441\u043d\u0443\u0442\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22281_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, (Attribute)AttributeRegistry.DURABILITY.get(), -0.15, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22281_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, (Attribute)AttributeRegistry.DURABILITY.get(), -0.3, AttributeModifier.Operation.MULTIPLY_BASE).build());
    public static final ReforgeType CRANKY = ReforgeRegistry.register(new ReforgeType.Builder("cranky").displayName("\u0420\u0430\u0441\u0448\u0430\u0442\u0430\u043d\u043d\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22283_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.3, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22283_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.6, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType AWFUL = ReforgeRegistry.register(new ReforgeType.Builder("awful").displayName("\u041e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22281_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, (Attribute)ForgeMod.ENTITY_REACH.get(), -0.5, AttributeModifier.Operation.ADDITION).modifier(1, (Attribute)AttributeReg.MISS_CHANCE.get(), 5.0, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22281_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, (Attribute)ForgeMod.ENTITY_REACH.get(), -1.0, AttributeModifier.Operation.ADDITION).modifier(2, (Attribute)AttributeReg.MISS_CHANCE.get(), 10.0, AttributeModifier.Operation.ADDITION).build());
    public static final ReforgeType CROOKED = ReforgeRegistry.register(new ReforgeType.Builder("crooked").displayName("\u041a\u0440\u0438\u0432\u043e\u0439").category(ReforgeType.Category.NEGATIVE).modifier(1, Attributes.f_22281_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE).modifier(1, Attributes.f_22282_, -0.1, AttributeModifier.Operation.ADDITION).modifier(2, Attributes.f_22281_, -0.1, AttributeModifier.Operation.MULTIPLY_BASE).modifier(2, Attributes.f_22282_, -0.2, AttributeModifier.Operation.ADDITION).build());

    public static ReforgeType register(ReforgeType type) {
        REGISTRY.put(type.getId(), type);
        return type;
    }

    public static List<ReforgeType> getByCategory(ReforgeType.Category category) {
        return REGISTRY.values().stream().filter(r -> r.getCategory() == category).toList();
    }

    public static Optional<ReforgeType> get(String id) {
        return Optional.ofNullable(REGISTRY.get(id));
    }

    public static Collection<ReforgeType> getAll() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }
}

