/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.core.reforge;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import pro.komaru.tridot.util.Col;
import ru.auriny.omegablacksmith.core.reforge.dto.AttributeModifierData;

public final class ReforgeType {
    private final String id;
    private final String displayName;
    private final Category category;
    private final Map<Integer, List<AttributeModifierData>> modifiers;

    private ReforgeType(String id, String displayName, Category category, Map<Integer, List<AttributeModifierData>> modifiers) {
        this.id = Objects.requireNonNull(id);
        this.displayName = Objects.requireNonNull(displayName);
        this.category = Objects.requireNonNull(category);
        this.modifiers = ImmutableMap.copyOf(modifiers);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Category getCategory() {
        return this.category;
    }

    public List<AttributeModifierData> getModifiers(int lvl) {
        return this.modifiers.getOrDefault(lvl, Collections.emptyList());
    }

    public boolean containsModifier(AttributeModifier mod, int level) {
        return this.getModifiers(level).stream().anyMatch(data -> data.matches(mod));
    }

    public List<AttributeModifierData> getModifiersCopy(int lvl) {
        return new ArrayList<AttributeModifierData>(this.getModifiers(lvl));
    }

    public Col getColor() {
        switch (this.category) {
            case NEGATIVE: {
                return Col.red;
            }
            case NEUTRAL: {
                return Col.lightGray;
            }
            case POSITIVE: {
                return Col.green;
            }
        }
        return Col.blue;
    }

    public static enum Category {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;

    }

    public static class Builder {
        private final String id;
        private String displayName;
        private Category category = Category.NEUTRAL;
        private final Map<Integer, List<AttributeModifierData>> map = new HashMap<Integer, List<AttributeModifierData>>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder displayName(String name) {
            this.displayName = name;
            return this;
        }

        public Builder category(Category c) {
            this.category = c;
            return this;
        }

        public Builder modifier(int level, Attribute attr, double amount, AttributeModifier.Operation op) {
            String name = "omegareforge_" + this.id + "_" + level;
            AttributeModifierData data = AttributeModifierData.of(this.id, level, attr, name, amount, op);
            this.map.computeIfAbsent(level, l -> new ArrayList()).add(data);
            return this;
        }

        public ReforgeType build() {
            if (this.displayName == null) {
                this.displayName = this.id;
            }
            return new ReforgeType(this.id, this.displayName, this.category, this.map);
        }
    }
}

