/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.mixin;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.auriny.omegablacksmith.OmegaBlacksmith;
import ru.auriny.omegablacksmith.core.reforge.ReforgeRegistry;
import ru.auriny.omegablacksmith.core.reforge.ReforgeType;
import ru.auriny.omegablacksmith.core.reforge.dto.AttributeModifierData;
import ru.auriny.omegablacksmith.core.registries.AttributeRegistry;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item m_41720_();

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectDurability(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        int base = this.m_41720_().getMaxDamage(stack);
        if (base <= 0) {
            return;
        }
        if (stack.m_41783_() != null && stack.m_41782_() && stack.m_41783_().m_128441_("DurabilityBonus")) {
            int bonus = stack.m_41783_().m_128451_("DurabilityBonus");
            cir.setReturnValue((Object)Math.max(1, base + bonus));
        }
    }

    @Inject(method={"getAttributeModifiers"}, at={@At(value="RETURN")}, cancellable=true)
    private void filterAndSortAttributes(EquipmentSlot slot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41619_()) {
            return;
        }
        Multimap original = (Multimap)cir.getReturnValue();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        int reforgeLevel = stack.m_41782_() && stack.m_41783_().m_128441_("ReforgeLevel") ? stack.m_41783_().m_128451_("ReforgeLevel") : 0;
        LinkedHashMultimap baseAttrs = LinkedHashMultimap.create();
        LinkedHashMultimap durabilityAttrs = LinkedHashMultimap.create();
        LinkedHashMultimap reforgeAttrs = LinkedHashMultimap.create();
        original.forEach((arg_0, arg_1) -> ItemStackMixin.lambda$filterAndSortAttributes$1(stack, reforgeLevel, (Multimap)durabilityAttrs, (Multimap)reforgeAttrs, (Multimap)baseAttrs, arg_0, arg_1));
        if (!(slot != EquipmentSlot.MAINHAND || baseAttrs.isEmpty() && reforgeAttrs.isEmpty())) {
            result.putAll((Multimap)baseAttrs);
            result.putAll((Multimap)durabilityAttrs);
        } else {
            result.putAll((Multimap)baseAttrs);
        }
        result.putAll((Multimap)reforgeAttrs);
        cir.setReturnValue((Object)result);
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    @GradleSideOnly(value={GradleSide.CLIENT})
    private Multimap<Attribute, AttributeModifier> redirectGetAttributeModifiersForTooltip(ItemStack stack, EquipmentSlot slot) {
        Multimap original = stack.m_41638_(slot);
        if (original == null || original.isEmpty() || slot != EquipmentSlot.MAINHAND || !stack.m_41782_()) {
            return original;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("ReforgeId") || !tag.m_128441_("ReforgeLevel")) {
            return original;
        }
        String reforgeId = tag.m_128461_("ReforgeId");
        int level = tag.m_128451_("ReforgeLevel");
        Optional<ReforgeType> reforgeOpt = ReforgeRegistry.get(reforgeId);
        if (reforgeOpt.isEmpty()) {
            return original;
        }
        ReforgeType reforge = reforgeOpt.get();
        List<AttributeModifierData> reforgeModifiers = reforge.getModifiers(level);
        if (reforgeModifiers.isEmpty()) {
            return original;
        }
        Set reforgeUuids = reforgeModifiers.stream().map(AttributeModifierData::uuid).collect(Collectors.toSet());
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : original.asMap().entrySet()) {
            double rounded;
            double displayedAdd;
            Attribute attr = (Attribute)entry.getKey();
            Collection mods = (Collection)entry.getValue();
            double baseAdd = 0.0;
            double reforAdd = 0.0;
            double baseMulBase = 0.0;
            double reforMulBase = 0.0;
            double baseMulTotalProd = 1.0;
            double reforMulTotalProd = 1.0;
            for (AttributeModifier mod : mods) {
                boolean isReforge = reforgeUuids.contains(mod.m_22209_());
                switch (mod.m_22217_()) {
                    case ADDITION: {
                        if (isReforge) {
                            reforAdd += mod.m_22218_();
                            break;
                        }
                        baseAdd += mod.m_22218_();
                        break;
                    }
                    case MULTIPLY_BASE: {
                        if (isReforge) {
                            reforMulBase += mod.m_22218_();
                            break;
                        }
                        baseMulBase += mod.m_22218_();
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        if (isReforge) {
                            reforMulTotalProd *= 1.0 + mod.m_22218_();
                            break;
                        }
                        baseMulTotalProd *= 1.0 + mod.m_22218_();
                        break;
                    }
                }
            }
            double combinedAdd = baseAdd + reforAdd;
            double combinedMulBaseFactor = 1.0 + (baseMulBase + reforMulBase);
            double combinedMulTotalFactor = baseMulTotalProd * reforMulTotalProd;
            double baseValue = attr.m_22082_();
            double finalValue = (baseValue + combinedAdd) * combinedMulBaseFactor * combinedMulTotalFactor;
            if (attr == AttributeRegistry.DURABILITY.get()) {
                int value = (int)Math.max(1.0, (double)stack.m_41776_() * combinedMulBaseFactor * combinedMulTotalFactor);
                result.put((Object)attr, (Object)new AttributeModifier(OmegaBlacksmith.BASE_DURABILITY_UUID, "Base durability", (double)value, AttributeModifier.Operation.ADDITION));
                continue;
            }
            if (attr.equals(Attributes.f_22283_)) {
                if (mods.isEmpty()) continue;
                AttributeModifier first = (AttributeModifier)mods.iterator().next();
                displayedAdd = finalValue - baseValue;
                rounded = (double)Math.round(displayedAdd * 1000.0) / 1000.0;
                result.put((Object)attr, (Object)new AttributeModifier(first.m_22209_(), first.m_22214_(), rounded, AttributeModifier.Operation.ADDITION));
                continue;
            }
            if (mods.isEmpty()) continue;
            AttributeModifier first = (AttributeModifier)mods.iterator().next();
            displayedAdd = finalValue - baseValue;
            rounded = (double)Math.round(displayedAdd * 1000.0) / 1000.0;
            result.put((Object)attr, (Object)new AttributeModifier(first.m_22209_(), first.m_22214_(), rounded, AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    private static /* synthetic */ void lambda$filterAndSortAttributes$1(ItemStack stack, int reforgeLevel, Multimap durabilityAttrs, Multimap reforgeAttrs, Multimap baseAttrs, Attribute att, AttributeModifier mod) {
        boolean isDurability = att == AttributeRegistry.DURABILITY.get();
        boolean isReforge = false;
        if (stack.m_41783_() != null && stack.m_41782_() && stack.m_41783_().m_128441_("ReforgeId") && reforgeLevel > 0) {
            String reforgeId = stack.m_41783_().m_128461_("ReforgeId");
            isReforge = ReforgeRegistry.get(reforgeId).map(r -> r.containsModifier(mod, reforgeLevel)).orElse(false);
        }
        if (isDurability) {
            durabilityAttrs.put((Object)att, (Object)mod);
        } else if (isReforge) {
            reforgeAttrs.put((Object)att, (Object)mod);
        } else {
            baseAttrs.put((Object)att, (Object)mod);
        }
    }
}

