/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.network.NetworkHooks;
import ru.auriny.omegablacksmith.core.menu.BlacksmithMenu;
import ru.auriny.omegablacksmith.core.reforge.ReforgeRegistry;
import ru.auriny.omegablacksmith.core.reforge.ReforgeType;

public class BlacksmithCommand {
    private static final SuggestionProvider<CommandSourceStack> REFORGE_SUGGESTIONS = (ctx, builder) -> {
        for (ReforgeType type : ReforgeRegistry.getAll()) {
            builder.suggest(type.getId());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"obs").requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(BlacksmithCommand::openBlacksmithMenu)))).then(Commands.m_82127_((String)"reforge").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).suggests(REFORGE_SUGGESTIONS).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BlacksmithCommand.applyReforge((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"id"), (Integer)ctx.getArgument("level", Integer.class)))))));
    }

    private static int applyReforge(CommandContext<CommandSourceStack> ctx, String id, int level) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof SwordItem) && !(stack.m_41720_() instanceof AxeItem)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u042d\u0442\u043e\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u0430\u043d"));
            return 0;
        }
        ReforgeType reforge = ReforgeRegistry.get(id).orElse(null);
        if (reforge == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 id \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0438: " + id)));
            return 0;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("ReforgeId", id);
        tag.m_128405_("ReforgeLevel", level);
        player.m_213846_((Component)Component.m_237113_((String)("\u2714 \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0430: " + reforge.getDisplayName() + " " + level)));
        return 1;
    }

    private static int openBlacksmithMenu(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        BlacksmithCommand.openBlackSmithMenuToPlayer(player);
        return 1;
    }

    public static void openBlackSmithMenuToPlayer(ServerPlayer player) {
        CompletableFuture.runAsync(() -> {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            Objects.requireNonNull(player.m_20194_()).execute(() -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new BlacksmithMenu(id, playerInventory, buffer), (Component)Component.m_237119_())));
        });
    }
}

