/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.server.reforge.util;

import java.util.List;
import pro.komaru.tridot.util.math.ArcRandom;
import ru.auriny.omegablacksmith.core.reforge.ReforgeRegistry;
import ru.auriny.omegablacksmith.core.reforge.ReforgeType;

public final class ReforgeRandomizer {
    private static final ArcRandom RANDOM = new ArcRandom();

    public static Result getRandom() {
        int level;
        ReforgeType type;
        List<ReforgeType> pool = ReforgeRegistry.getAll().stream().toList();
        if (pool.isEmpty()) {
            throw new IllegalStateException("\u041d\u0435\u0442 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043e\u043a!");
        }
        int rollCategory = RANDOM.random(100);
        if (rollCategory < 30) {
            List<ReforgeType> positives = pool.stream().filter(r -> r.getCategory() == ReforgeType.Category.POSITIVE).toList();
            type = positives.get(RANDOM.random(positives.size() - 1));
            rollCategory = RANDOM.random(100);
            level = rollCategory < 3 ? 2 : 1;
        } else if (rollCategory < 65) {
            List<ReforgeType> neutrals = pool.stream().filter(r -> r.getCategory() == ReforgeType.Category.NEUTRAL).toList();
            type = neutrals.get(RANDOM.random(neutrals.size() - 1));
            rollCategory = RANDOM.random(100);
            level = rollCategory < 5 ? 2 : 1;
        } else {
            List<ReforgeType> negatives = pool.stream().filter(r -> r.getCategory() == ReforgeType.Category.NEGATIVE).toList();
            type = negatives.get(RANDOM.random(negatives.size() - 1));
            rollCategory = RANDOM.random(100);
            level = rollCategory < 6 ? 2 : 1;
        }
        return new Result(type, level);
    }

    public record Result(ReforgeType type, int level) {
    }
}

