/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.server.task;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import pro.komaru.tridot.util.Tmp;
import ru.auriny.omegablacksmith.core.network.GetMultiplierPacket;
import ru.auriny.omegablacksmith.core.network.NetMessages;
import ru.auriny.omegablacksmith.core.registries.CapabilityRegistry;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public class MultiplierDecayTask {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void start() {
        scheduler.scheduleAtFixedRate(MultiplierDecayTask::tick, 10L, 10L, TimeUnit.MINUTES);
    }

    private static void tick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        server.execute(() -> {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.getCapability(CapabilityRegistry.REFORGE_MULTIPLIER_CAPABILITY).ifPresent(cap -> {
                    if (Tmp.rnd.chance(0.33) && cap.getMultiplier() > 1.0f) {
                        cap.setMultiplier(Math.max(1.0f, cap.getMultiplier() - 0.1f));
                        NetMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GetMultiplierPacket(cap.getMultiplier()));
                    }
                    if (cap.getMultiplier() < 1.0f) {
                        if (cap.getMultiplier() + 0.1f > 1.0f) {
                            cap.setMultiplier(1.0f);
                        } else {
                            cap.setMultiplier(cap.getMultiplier() + 0.1f);
                        }
                    }
                });
            }
        });
    }
}

