/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.auriny.omegabuyer.core.menu.BuyerMenu;
import ru.auriny.omegabuyer.core.net.NetMessages;
import ru.auriny.omegabuyer.core.net.packet.BuyerClickPacket;

public class BuyerScreen
extends AbstractContainerScreen<BuyerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("omegabuyer", "textures/gui/buyer.png");
    private long nextUpdateTime;
    private static final List<int[]> SLOT_COORDS = List.of(new int[]{79, 31}, new int[]{113, 31}, new int[]{146, 31}, new int[]{79, 66}, new int[]{113, 66}, new int[]{146, 66});
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private final List<Float> prices = new ArrayList<Float>();
    private final List<Integer> limits = new ArrayList<Integer>();
    private final List<Integer> soldList = new ArrayList<Integer>();

    public BuyerScreen(BuyerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 183;
        this.f_97728_ = 10;
        this.f_97729_ = 10;
        this.f_97730_ = 10;
        this.f_97731_ = 87;
        this.items.addAll(menu.syncedItems);
        this.prices.addAll(menu.syncedPrices);
        this.nextUpdateTime = menu.syncedNextUpdate;
    }

    private void renderTexts(GuiGraphics gfx) {
        float factor = 0.72f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        PoseStack pose = gfx.m_280168_();
        pose.m_85836_();
        pose.m_85841_(factor, factor, 1.0f);
        long remaining = this.nextUpdateTime - System.currentTimeMillis();
        if (remaining < 0L) {
            remaining = 0L;
        }
        long s = remaining / 1000L % 60L;
        long m = remaining / 60000L % 60L;
        long h = remaining / 3600000L;
        String timeStr = String.format("%02d:%02d:%02d", h, m, s);
        this.placeStr((Component)Component.m_237113_((String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0447\u0435\u0440\u0435\u0437:"), gfx, 93, 4, factor, 0xFFFFFF);
        this.placeStr((Component)Component.m_237113_((String)timeStr), gfx, 93, 11, factor, 65280);
        pose.m_85849_();
    }

    private void renderItems(GuiGraphics gfx) {
        PoseStack pose = gfx.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.items.isEmpty()) {
            return;
        }
        pose.m_85836_();
        float mainScale = 1.97f;
        pose.m_85841_(mainScale, mainScale, mainScale);
        this.placeItem(this.items.get(0), gfx, 22, 42, mainScale);
        pose.m_85849_();
        for (int i = 1; i < this.items.size() && i - 1 < SLOT_COORDS.size(); ++i) {
            int[] pos = SLOT_COORDS.get(i - 1);
            this.placeItem(this.items.get(i), gfx, pos[0], pos[1], 1.0f);
        }
    }

    private void placeStr(Component component, GuiGraphics gfx, int x, int y, float factor, int color) {
        gfx.m_280614_(this.f_96547_, component, (int)((float)(this.f_97735_ + x) / factor), (int)((float)(this.f_97736_ + y) / factor), color, true);
    }

    private void placeItem(ItemStack stack, GuiGraphics gfx, int x, int y, float factor) {
        gfx.m_280480_(stack, Math.round((float)(this.f_97735_ + x) / factor), Math.round((float)(this.f_97736_ + y) / factor));
    }

    private void placeImg(ResourceLocation texture, GuiGraphics gfx, int x, int y, float factor) {
        gfx.m_280218_(texture, (int)((float)(this.f_97735_ + x) / factor), (int)((float)(this.f_97736_ + y) / factor), 0, 0, 16, 16);
    }

    private void renderHoveredItemTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        for (int i = 0; i < this.items.size(); ++i) {
            int size;
            int y;
            int x;
            if (i == 0) {
                x = this.f_97735_ + 22;
                y = this.f_97736_ + 42;
                size = Math.round(31.52f);
            } else {
                int[] pos = SLOT_COORDS.get(i - 1);
                x = this.f_97735_ + pos[0];
                y = this.f_97736_ + pos[1];
                size = 16;
            }
            if (mouseX < x || mouseX > x + size || mouseY < y || mouseY > y + size) continue;
            ItemStack stack = this.items.get(i);
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(stack.m_41786_());
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237113_((String)("\u00a77\u0426\u0435\u043d\u0430: \u00a7a" + String.valueOf(this.prices.get(i)) + " \u2662")));
            int sold = this.soldList.size() > i ? this.soldList.get(i) : 0;
            int limit = this.limits.size() > i ? this.limits.get(i) : 0;
            String limitStr = limit == Integer.MAX_VALUE ? "\u221e" : sold + "/" + limit;
            tooltip.add(Component.m_237113_((String)("\u00a77\u041b\u0438\u043c\u0438\u0442: \u00a7b" + limitStr)));
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438 \u041b\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0434\u0430\u0442\u044c!").m_130940_(ChatFormatting.GRAY));
            gfx.m_280677_(this.f_96547_, tooltip, stack.m_150921_(), mouseX, mouseY);
            return;
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderTexts(guiGraphics);
        this.renderItems(guiGraphics);
        this.renderHoveredItemTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.items.size(); ++i) {
            int size;
            int y;
            int x;
            if (i == 0) {
                x = this.f_97735_ + 22;
                y = this.f_97736_ + 42;
                size = Math.round(31.52f);
            } else {
                int[] pos = SLOT_COORDS.get(i - 1);
                x = this.f_97735_ + pos[0];
                y = this.f_97736_ + pos[1];
                size = 16;
            }
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + size)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + size)) || this.f_96541_ == null) continue;
            NetMessages.CHANNEL.sendToServer((Object)new BuyerClickPacket(i, 1));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void setNextUpdateTime(long timestamp) {
        this.nextUpdateTime = timestamp;
    }

    public void syncItems(List<ItemStack> stacks, List<Float> prices, List<Integer> limits, List<Integer> sold) {
        this.items.clear();
        this.prices.clear();
        this.limits.clear();
        this.soldList.clear();
        this.items.addAll(stacks);
        this.prices.addAll(prices);
        this.limits.addAll(limits);
        this.soldList.addAll(sold);
    }
}

