/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.core.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ru.auriny.omegabuyer.OmegaBuyer;
import ru.auriny.omegabuyer.core.registries.MenuRegistry;

public class BuyerMenu
extends AbstractContainerMenu {
    public final SimpleContainer container;
    public final List<ItemStack> syncedItems = new ArrayList<ItemStack>();
    public final List<Float> syncedPrices = new ArrayList<Float>();
    public long syncedNextUpdate = System.currentTimeMillis() + 60000L;

    public BuyerMenu(int id, Inventory playerInventory) {
        super((MenuType)MenuRegistry.BUYER_MENU.get(), id);
        this.container = new SimpleContainer(1);
        this.initializeDefaults();
        this.addPlayerSlots(playerInventory);
        OmegaBuyer.LOGGER.info("BuyerMenu created with defaults ({} items)", (Object)this.syncedItems.size());
    }

    public BuyerMenu(int id, @NotNull Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)MenuRegistry.BUYER_MENU.get(), id);
        this.container = new SimpleContainer(1);
        if (buf != null && buf.isReadable()) {
            try {
                List items = buf.m_236845_(FriendlyByteBuf::m_130267_);
                List prices = buf.m_236845_(FriendlyByteBuf::readFloat);
                this.syncedNextUpdate = buf.readLong();
                this.syncedItems.addAll(items);
                this.syncedPrices.addAll(prices);
                if (this.syncedItems.size() != this.syncedPrices.size()) {
                    throw new IllegalArgumentException("Items and prices size mismatch: " + this.syncedItems.size() + " vs " + this.syncedPrices.size());
                }
                OmegaBuyer.LOGGER.info("BuyerMenu created with {} items from buffer", (Object)this.syncedItems.size());
            }
            catch (Exception e) {
                OmegaBuyer.LOGGER.error("Error reading BuyerMenu buffer: {}", (Object)e.getMessage(), (Object)e);
                this.initializeDefaults();
            }
        } else {
            OmegaBuyer.LOGGER.warn("Empty or null buffer in BuyerMenu, using defaults");
            this.initializeDefaults();
        }
        this.addPlayerSlots(playerInventory);
    }

    private void initializeDefaults() {
        for (int i = 0; i < 6; ++i) {
            this.syncedItems.add(i == 0 ? new ItemStack((ItemLike)Items.f_42127_) : ItemStack.f_41583_);
            this.syncedPrices.add(Float.valueOf(0.0f));
        }
    }

    private void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 101 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 159));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int i) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }
}

