/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.core.net.packet;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.komarueconomy.config.Config;
import ru.auriny.komarueconomy.core.EconomyManager;
import ru.auriny.omegabuyer.server.registries.ServerTradeRegistry;

public class BuyerClickPacket {
    private final int index;
    private final int amount;

    public BuyerClickPacket(int index, int amount) {
        this.index = index;
        this.amount = amount;
    }

    public static void encode(BuyerClickPacket pkt, FriendlyByteBuf buf) {
        buf.m_130130_(pkt.index);
        buf.m_130130_(pkt.amount);
    }

    public static BuyerClickPacket decode(FriendlyByteBuf buf) {
        return new BuyerClickPacket(buf.m_130242_(), buf.m_130242_());
    }

    public static void handle(BuyerClickPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CompletableFuture.runAsync(() -> BuyerClickPacket.lambda$handle$1((Supplier)ctx, pkt)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Supplier ctx, BuyerClickPacket pkt) {
        int totalLimit;
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        if (player == null) {
            return;
        }
        if (pkt.index < 0 || pkt.index >= ServerTradeRegistry.CURRENT_DISPLAY.size()) {
            return;
        }
        ServerTradeRegistry.TradeEntry entry = ServerTradeRegistry.CURRENT_DISPLAY.get(pkt.index);
        if (entry == null) {
            return;
        }
        int inInv = player.m_150109_().m_18947_(entry.item());
        int sell = Math.min(pkt.amount, inInv);
        if (sell <= 0) {
            return;
        }
        int n = totalLimit = entry.limited() ? entry.totalLimit() : Integer.MAX_VALUE;
        if (entry.limited()) {
            int alreadySold = ServerTradeRegistry.getPlayerSold(player, pkt.index);
            int remainForPlayer = Math.max(0, totalLimit - alreadySold);
            sell = Math.min(sell, remainForPlayer);
        }
        if (sell <= 0) {
            return;
        }
        int removed = player.m_150109_().m_36022_(s -> s.m_150930_(entry.item()), sell, (Container)player.m_150109_());
        if (removed < sell) {
            return;
        }
        float earned = entry.price() * (float)sell;
        EconomyManager.deposit((String)player.m_5446_().getString(), (double)earned);
        if (entry.limited()) {
            ServerTradeRegistry.incrementPlayerSold(player, pkt.index, sell);
        }
        player.m_213846_((Component)Config.getPrefix().m_6881_().m_7220_((Component)Component.m_237113_((String)("+" + earned + Config.getCurrencySymbol()))).m_130940_(ChatFormatting.GREEN));
    }
}

