/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.core.net.packet;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.omegabuyer.OmegaBuyer;
import ru.auriny.omegabuyer.client.screen.BuyerScreen;

public class SyncBuyerItemsPacket {
    private final List<ItemStack> items;
    private final List<Float> prices;
    private final List<Integer> totals;
    private final List<Integer> solds;
    private final long nextUpdateTimestamp;

    public SyncBuyerItemsPacket(List<ItemStack> items, List<Float> prices, List<Integer> totals, List<Integer> solds, long nextUpdateTimestamp) {
        this.items = items;
        this.prices = prices;
        this.totals = totals;
        this.solds = solds;
        this.nextUpdateTimestamp = nextUpdateTimestamp;
    }

    public static void encode(SyncBuyerItemsPacket pkt, FriendlyByteBuf buf) {
        buf.m_236828_(pkt.items, FriendlyByteBuf::m_130055_);
        buf.m_236828_(pkt.prices, FriendlyByteBuf::writeFloat);
        buf.m_236828_(pkt.totals, FriendlyByteBuf::m_130130_);
        buf.m_236828_(pkt.solds, FriendlyByteBuf::m_130130_);
        buf.writeLong(pkt.nextUpdateTimestamp);
    }

    public static SyncBuyerItemsPacket decode(FriendlyByteBuf buf) {
        List list = buf.m_236845_(FriendlyByteBuf::m_130267_);
        List prices = buf.m_236845_(FriendlyByteBuf::readFloat);
        List totals = buf.m_236845_(FriendlyByteBuf::m_130242_);
        List solds = buf.m_236845_(FriendlyByteBuf::m_130242_);
        long time = buf.readLong();
        return new SyncBuyerItemsPacket(list, prices, totals, solds, time);
    }

    public static void handle(SyncBuyerItemsPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt2085$temp = mc.f_91080_;
            if (patt2085$temp instanceof BuyerScreen) {
                BuyerScreen screen = (BuyerScreen)patt2085$temp;
                screen.syncItems(pkt.items, pkt.prices, pkt.totals, pkt.solds);
                screen.setNextUpdateTime(pkt.nextUpdateTimestamp);
                OmegaBuyer.LOGGER.info("Synced buyer items to screen: {} items", (Object)pkt.items.size());
            } else {
                OmegaBuyer.LOGGER.debug("SyncBuyerItemsPacket received, but no BuyerScreen open");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

