/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;
import ru.auriny.omegabuyer.core.menu.BuyerMenu;
import ru.auriny.omegabuyer.server.registries.ServerTradeRegistry;
import ru.auriny.omegabuyer.server.task.BuyerReloadTask;

public class BuyerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"buyer").requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(BuyerCommand::openBuyerMenu)))).then(Commands.m_82127_((String)"reload").executes(ctx -> BuyerCommand.reloadBuyer((CommandSourceStack)ctx.getSource())))).executes(ctx -> BuyerCommand.openBuyerMenuToPlayer(((CommandSourceStack)ctx.getSource()).m_230896_())));
    }

    private static int reloadBuyer(CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        BuyerReloadTask.reloadNow(server);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u0421\u043a\u0443\u043f\u0449\u0438\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d \u0432\u0440\u0443\u0447\u043d\u0443\u044e!"), true);
        return 1;
    }

    private static int openBuyerMenu(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        BuyerCommand.openBuyerMenuToPlayer(player);
        return 1;
    }

    public static int openBuyerMenuToPlayer(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return 0;
        }
        if (ServerTradeRegistry.CURRENT_DISPLAY.isEmpty()) {
            BuyerReloadTask.reloadNow(server);
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Float> prices = new ArrayList<Float>();
        for (ServerTradeRegistry.TradeEntry e : ServerTradeRegistry.CURRENT_DISPLAY) {
            if (e != null) {
                stacks.add(e.asStack());
                prices.add(Float.valueOf(e.price()));
                continue;
            }
            stacks.add(ItemStack.f_41583_);
            prices.add(Float.valueOf(0.0f));
        }
        buffer.m_236828_(stacks, FriendlyByteBuf::m_130055_);
        buffer.m_236828_(prices, FriendlyByteBuf::writeFloat);
        buffer.writeLong(BuyerReloadTask.getNextUpdateTimestamp());
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new BuyerMenu(id, playerInventory, buffer), (Component)Component.m_237119_()));
        ServerTradeRegistry.sendToPlayer(server, player);
        return 1;
    }
}

