/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.server.event;

import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.auriny.omegabuyer.OmegaBuyer;
import ru.auriny.omegabuyer.server.registries.ServerTradeRegistry;
import ru.auriny.omegabuyer.server.task.BuyerReloadTask;

@Mod.EventBusSubscriber(modid="omegabuyer", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        BuyerReloadTask.init(event.getServer());
        BuyerReloadTask.reloadNow(event.getServer());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long nextUpdate;
        long currentTime;
        if (!BuyerReloadTask.isInitialized || event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server == null || !server.m_130010_()) {
            return;
        }
        long currentTick = server.m_129921_();
        if (currentTick % 100L == 0L) {
            OmegaBuyer.LOGGER.debug("Buyer tick active: tick={}, next timestamp={}, players={}, entries={}", new Object[]{currentTick, BuyerReloadTask.getNextUpdateTimestamp(), server.m_6846_().m_11314_().size(), ServerTradeRegistry.getEntries().size()});
        }
        if ((currentTime = System.currentTimeMillis()) >= (nextUpdate = BuyerReloadTask.getNextUpdateTimestamp())) {
            OmegaBuyer.LOGGER.debug("Auto-reload triggered by timestamp at {} (currentTime={}, next was {})", new Object[]{currentTick, currentTime, nextUpdate});
            BuyerReloadTask.reloadNow(server);
            long newNext = currentTime + 0x200B20L;
            BuyerReloadTask.setNextUpdateTimestamp(newNext);
            OmegaBuyer.LOGGER.debug("Next auto-reload scheduled at timestamp {}", (Object)newNext);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        BuyerReloadTask.stop();
    }
}

