/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.server.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import ru.auriny.omegabuyer.core.net.NetMessages;
import ru.auriny.omegabuyer.core.net.packet.SyncBuyerItemsPacket;
import ru.auriny.omegabuyer.server.task.BuyerReloadTask;

public class ServerTradeRegistry {
    public static List<TradeEntry> CURRENT_DISPLAY = new ArrayList<TradeEntry>();
    private static long NEXT_UPDATE = 0L;
    private static final List<TradeEntry> ENTRIES = new ArrayList<TradeEntry>();
    private static final ArcRandom RAND = Tmp.rnd;
    private static final Map<UUID, int[]> PLAYER_SOLD = new ConcurrentHashMap<UUID, int[]>();

    public static void registerUnlimited(ResourceLocation itemRL, float priceFirst) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRL);
        if (item == null) {
            System.err.println("[OmegaBuyer] \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + String.valueOf(itemRL));
            return;
        }
        ENTRIES.add(new TradeEntry(item, ServerTradeRegistry.randomize(priceFirst), false, Integer.MAX_VALUE));
    }

    public static void registerLimited(ResourceLocation itemRL, float priceFirst, int limitFirst) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRL);
        if (item == null) {
            System.err.println("[OmegaBuyer] \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + String.valueOf(itemRL));
            return;
        }
        ENTRIES.add(new TradeEntry(item, ServerTradeRegistry.randomize(priceFirst), true, (int)ServerTradeRegistry.randomize(limitFirst)));
    }

    public static void registerUnlimited(Item item, float priceFirst) {
        ENTRIES.add(new TradeEntry(item, ServerTradeRegistry.randomize(priceFirst), false, Integer.MAX_VALUE));
    }

    public static void registerLimited(Item item, float priceFirst, int limitFirst) {
        ENTRIES.add(new TradeEntry(item, ServerTradeRegistry.randomize(priceFirst), true, (int)ServerTradeRegistry.randomize(limitFirst)));
    }

    public static List<TradeEntry> getEntries() {
        return ENTRIES;
    }

    public static void onReload() {
    }

    public static void sendToPlayer(MinecraftServer server, ServerPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Float> prices = new ArrayList<Float>();
        ArrayList<Integer> totals = new ArrayList<Integer>();
        ArrayList<Integer> solds = new ArrayList<Integer>();
        ServerTradeRegistry.ensurePlayerData(player);
        for (int i = 0; i < CURRENT_DISPLAY.size(); ++i) {
            TradeEntry e = CURRENT_DISPLAY.get(i);
            if (e != null) {
                stacks.add(e.asStack());
                prices.add(Float.valueOf(e.price));
                totals.add(e.limited ? e.totalLimit : Integer.MAX_VALUE);
                solds.add(ServerTradeRegistry.getPlayerSold(player, i));
                continue;
            }
            stacks.add(ItemStack.f_41583_);
            prices.add(Float.valueOf(0.0f));
            totals.add(0);
            solds.add(0);
        }
        NetMessages.CHANNEL.sendTo((Object)new SyncBuyerItemsPacket(stacks, prices, totals, solds, NEXT_UPDATE), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void ensurePlayerData(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID id = player.m_20148_();
        int size = CURRENT_DISPLAY.size();
        PLAYER_SOLD.compute(id, (k, arr) -> {
            if (arr == null || ((int[])arr).length != size) {
                int[] newArr = new int[size];
                if (arr != null) {
                    System.arraycopy(arr, 0, newArr, 0, Math.min(((int[])arr).length, newArr.length));
                }
                return newArr;
            }
            return arr;
        });
    }

    public static int getPlayerSold(ServerPlayer player, int index) {
        if (player == null) {
            return 0;
        }
        ServerTradeRegistry.ensurePlayerData(player);
        int[] arr = PLAYER_SOLD.get(player.m_20148_());
        if (arr == null || index < 0 || index >= arr.length) {
            return 0;
        }
        return arr[index];
    }

    public static void incrementPlayerSold(ServerPlayer player, int index, int amount) {
        int newVal;
        int limit;
        if (player == null) {
            return;
        }
        if (index < 0 || index >= CURRENT_DISPLAY.size()) {
            return;
        }
        ServerTradeRegistry.ensurePlayerData(player);
        int[] arr = PLAYER_SOLD.get(player.m_20148_());
        TradeEntry entry = CURRENT_DISPLAY.get(index);
        int n = entry == null ? 0 : (limit = entry.limited ? entry.totalLimit : Integer.MAX_VALUE);
        if (limit == Integer.MAX_VALUE) {
            arr[index] = arr[index] + amount;
            return;
        }
        arr[index] = newVal = Math.min(limit, arr[index] + amount);
    }

    public static void refreshDisplay(long nextUpdateTime) {
        CURRENT_DISPLAY = ServerTradeRegistry.buildDisplayEntriesInternal();
        NEXT_UPDATE = nextUpdateTime;
        PLAYER_SOLD.clear();
    }

    private static List<TradeEntry> buildDisplayEntriesInternal() {
        ArrayList<TradeEntry> out = new ArrayList<TradeEntry>();
        ArrayList<TradeEntry> unlimiteds = new ArrayList<TradeEntry>(ENTRIES.stream().filter(e -> !e.limited).toList());
        Collections.shuffle(unlimiteds, (Random)RAND);
        if (!unlimiteds.isEmpty()) {
            out.add((TradeEntry)unlimiteds.get(0));
            unlimiteds.remove(0);
        } else {
            out.add(null);
        }
        ArrayList<TradeEntry> limiteds = new ArrayList<TradeEntry>(ENTRIES.stream().filter(e -> e.limited).toList());
        Collections.shuffle(limiteds, (Random)RAND);
        for (int i = 0; i < 6; ++i) {
            if (i < limiteds.size()) {
                out.add((TradeEntry)limiteds.get(i));
                continue;
            }
            out.add(null);
        }
        return out;
    }

    public static void broadcastToAll(MinecraftServer server) {
        long time = BuyerReloadTask.getNextUpdateTimestamp();
        for (ServerPlayer p : server.m_6846_().m_11314_()) {
            ServerTradeRegistry.ensurePlayerData(p);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Float> prices = new ArrayList<Float>();
            ArrayList<Integer> totals = new ArrayList<Integer>();
            ArrayList<Integer> solds = new ArrayList<Integer>();
            for (int i = 0; i < CURRENT_DISPLAY.size(); ++i) {
                TradeEntry e = CURRENT_DISPLAY.get(i);
                if (e != null) {
                    stacks.add(e.asStack());
                    prices.add(Float.valueOf(e.price));
                    totals.add(e.limited ? e.totalLimit : Integer.MAX_VALUE);
                    solds.add(ServerTradeRegistry.getPlayerSold(p, i));
                    continue;
                }
                stacks.add(ItemStack.f_41583_);
                prices.add(Float.valueOf(0.0f));
                totals.add(0);
                solds.add(0);
            }
            NetMessages.CHANNEL.sendTo((Object)new SyncBuyerItemsPacket(stacks, prices, totals, solds, time), p.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static float randomize(float base) {
        float factor = Tmp.rnd.random(0.8f, 1.2f);
        float price = base * factor;
        price = (float)Math.round(price * 100.0f) / 100.0f;
        return Math.max(0.0f, price);
    }

    public record TradeEntry(Item item, float price, boolean limited, int totalLimit) {
        public ItemStack asStack() {
            return new ItemStack((ItemLike)this.item);
        }
    }
}

