/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegabuyer.server.task;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Items;
import ru.auriny.omegabuyer.OmegaBuyer;
import ru.auriny.omegabuyer.server.registries.ServerTradeRegistry;

public class BuyerReloadTask {
    public static final int MINS = 35;
    private static long nextUpdateTimestamp = 0L;
    public static boolean isInitialized = false;

    public static void init(MinecraftServer server) {
        if (server == null || isInitialized || !server.m_130010_()) {
            OmegaBuyer.LOGGER.warn("BuyerReloadTask init skipped: server invalid, already init, or not running");
            return;
        }
        long currentTime = System.currentTimeMillis();
        nextUpdateTimestamp = currentTime + 0x200B20L;
        OmegaBuyer.LOGGER.debug("BuyerReloadTask init: current time={}, next timestamp={}, entries size={}", new Object[]{currentTime, nextUpdateTimestamp, ServerTradeRegistry.getEntries().size()});
        BuyerReloadTask.reloadNow(server);
        isInitialized = true;
        OmegaBuyer.LOGGER.debug("BuyerReloadTask fully initialized for {} min auto-reloads", (Object)35);
    }

    public static void reloadNow(MinecraftServer server) {
        if (server == null || !server.m_130010_()) {
            OmegaBuyer.LOGGER.warn("reloadNow skipped: server null or not running");
            return;
        }
        if (!isInitialized) {
            OmegaBuyer.LOGGER.warn("Task not initialized in reloadNow \u2014 forcing init");
            if (!isInitialized) {
                OmegaBuyer.LOGGER.error("Force init failed! Skipping reload");
                return;
            }
        }
        long currentTime = System.currentTimeMillis();
        nextUpdateTimestamp = currentTime + 0x200B20L;
        int entriesSize = ServerTradeRegistry.getEntries().size();
        if (entriesSize == 0) {
            OmegaBuyer.LOGGER.warn("ENTRIES empty in reloadNow! Adding fallback vanilla trades");
            ServerTradeRegistry.registerUnlimited(Items.f_41905_, 1.0f);
            ServerTradeRegistry.registerUnlimited(Items.f_42415_, 10.0f);
            ServerTradeRegistry.registerUnlimited(Items.f_42616_, 8.5f);
            ServerTradeRegistry.registerLimited(Items.f_42686_, 500.1f, 2);
            entriesSize = ServerTradeRegistry.getEntries().size();
            OmegaBuyer.LOGGER.debug("Fallback trades added: now {} entries", (Object)entriesSize);
        }
        OmegaBuyer.LOGGER.debug("Starting reload: entries={}, display before={}", (Object)entriesSize, (Object)ServerTradeRegistry.CURRENT_DISPLAY.size());
        ServerTradeRegistry.onReload();
        ServerTradeRegistry.refreshDisplay(nextUpdateTimestamp);
        ServerTradeRegistry.broadcastToAll(server);
        OmegaBuyer.LOGGER.debug("Buyer reloaded: timestamp={}, display size={}, broadcast to {} players", new Object[]{nextUpdateTimestamp, ServerTradeRegistry.CURRENT_DISPLAY.size(), server.m_6846_().m_11314_().size()});
        if (!server.m_6846_().m_11314_().isEmpty()) {
            MutableComponent msg = Component.m_237113_((String)"\u0421\u043a\u0443\u043f\u0449\u0438\u043a \u043e\u0431\u043d\u043e\u0432\u0438\u043b \u0442\u043e\u0432\u0430\u0440\u044b!").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
            for (ServerPlayer p : server.m_6846_().m_11314_()) {
                p.m_5661_((Component)msg, false);
                p.m_6330_((SoundEvent)SoundEvents.f_12211_.m_203334_(), p.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public static void stop() {
        OmegaBuyer.LOGGER.info("BuyerReloadTask stopping");
        isInitialized = false;
        nextUpdateTimestamp = 0L;
    }

    public static long getNextUpdateTimestamp() {
        return nextUpdateTimestamp;
    }

    public static void setNextUpdateTimestamp(long timestamp) {
        nextUpdateTimestamp = timestamp;
    }
}

