/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import ua.omega.omegaduels.config.ServerConfig;
import ua.omega.omegaduels.duel.DuelSettings;
import ua.omega.omegaduels.network.PacketHandler;
import ua.omega.omegaduels.network.packets.C2S_CancelDuelPacket;
import ua.omega.omegaduels.network.packets.C2S_CancelReadyPacket;
import ua.omega.omegaduels.network.packets.C2S_PlayerReadyPacket;
import ua.omega.omegaduels.network.packets.C2S_RequestArenaListPacket;
import ua.omega.omegaduels.network.packets.C2S_SelectArenaPacket;
import ua.omega.omegaduels.network.packets.C2S_UpdateDuelSettingPacket;
import ua.omega.omegaduels.network.packets.S2C_ArenaListPacket;
import ua.omega.omegaduels.network.packets.S2C_DuelInfoPacket;

@OnlyIn(value=Dist.CLIENT)
public class DuelPrepScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/background.png");
    private static final ResourceLocation ARMOR_SLOTS_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/armor.png");
    private static final ResourceLocation INVENTORY_SLOTS_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/slots.png");
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/button.png");
    private static final ResourceLocation CUR_SLOTS_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/curios.png");
    private Tab currentTab = Tab.OVERVIEW;
    int scrollY = 0;
    private final Map<String, ArenaButton> arenaButtons = new HashMap<String, ArenaButton>();
    private final String selfName;
    private final UUID opponentUUID;
    private final NonNullList<ItemStack> opponentMainInventory;
    private final NonNullList<ItemStack> opponentArmorInventory;
    private final NonNullList<ItemStack> opponentCuriosInventory;
    private final LocalPlayer localPlayer;
    private DuelSettings currentSettings = new DuelSettings();
    private boolean localPlayerReady = false;
    private boolean opponentReady = false;
    private final Map<String, Button> settingButtons = new HashMap<String, Button>();
    private int guiWidth;
    private int guiHeight;
    private int leftPos;
    private int topPos;
    private int contentX;
    private int contentY;
    private int contentWidth;
    private int contentHeight;
    private String countdownTitle = "";
    private long countdownStartTime = 0L;
    private int countdownDuration = 0;
    private final int selfWins;
    private final int selfLosses;
    private final int opponentWins;
    private final int opponentLosses;
    private List<S2C_ArenaListPacket.ArenaInfo> arenaData = new ArrayList<S2C_ArenaListPacket.ArenaInfo>();
    private boolean canSelectArena;
    private int arenaScrollY = 0;

    public DuelPrepScreen(S2C_DuelInfoPacket msg) {
        super((Component)Component.m_237113_((String)"Duel Preparation"));
        this.selfName = msg.getSelfName();
        this.opponentUUID = msg.getOpponentUUID();
        this.opponentMainInventory = msg.getOpponentMainInventory();
        this.opponentArmorInventory = msg.getOpponentArmorInventory();
        this.opponentCuriosInventory = msg.getOpponentCuriosInventory();
        this.localPlayer = Minecraft.m_91087_().f_91074_;
        this.selfWins = msg.getSelfWins();
        this.selfLosses = msg.getSelfLosses();
        this.opponentWins = msg.getOpponentWins();
        this.opponentLosses = msg.getOpponentLosses();
        PacketHandler.INSTANCE.sendToServer((Object)new C2S_RequestArenaListPacket());
    }

    protected void m_7856_() {
        int tabsStartY;
        super.m_7856_();
        this.m_169413_();
        int maxWidth = 420;
        int maxHeight = 280;
        this.guiWidth = Math.min(420, this.f_96543_ - 20);
        this.guiHeight = Math.min(280, this.f_96544_ - 20);
        this.leftPos = (this.f_96543_ - this.guiWidth) / 2;
        this.topPos = (this.f_96544_ - this.guiHeight) / 2;
        int tabWidth = 130;
        int tabHeight = 20;
        int tabGap = 4;
        int numTabs = 4;
        int totalTabsHeight = 92;
        int currentTabY = tabsStartY = this.topPos + (this.guiHeight - 92) / 2;
        this.m_142416_((GuiEventListener)new TabButton(this.leftPos + 5, currentTabY, 130, "\u2605 \u041e\u0431\u0437\u043e\u0440", Tab.OVERVIEW));
        this.m_142416_((GuiEventListener)new TabButton(this.leftPos + 5, currentTabY += 24, 130, "\u0412\u0430\u0448 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c", Tab.SELF_INVENTORY));
        this.m_142416_((GuiEventListener)new TabButton(this.leftPos + 5, currentTabY += 24, 130, "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0421\u043e\u043f\u0435\u0440\u043d\u0438\u043a\u0430", Tab.OPPONENT_INVENTORY));
        this.m_142416_((GuiEventListener)new TabButton(this.leftPos + 5, currentTabY += 24, 130, "\u2699 \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", Tab.SETTINGS));
        this.contentX = this.leftPos + 130 + 10;
        this.contentY = this.topPos + 10;
        this.contentWidth = this.guiWidth - 130 - 20;
        this.contentHeight = this.guiHeight - 20;
        int settingButtonWidth = Math.min(240, this.contentWidth - 10);
        int settingsX = this.contentX + (this.contentWidth - settingButtonWidth) / 2;
        int settingsY = this.contentY + 20;
        this.settingButtons.put("keepInventory", (Button)this.m_142416_((GuiEventListener)new DuelSettingButton(settingsX, settingsY, settingButtonWidth, 22, "keepInventory", "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f")));
        settingsY += 27;
        int maxVisible = 6;
        List bannedItems = (List)ServerConfig.BANNED_ITEMS.get();
        boolean needScroll = bannedItems.size() > maxVisible;
        int index = 0;
        for (String entry : bannedItems) {
            if (!needScroll || index >= this.scrollY && index < this.scrollY + maxVisible) {
                String[] parts = entry.split(";", 2);
                String itemId = parts[0];
                String displayName = parts.length > 1 ? parts[1] : itemId;
                this.settingButtons.put(itemId, (Button)this.m_142416_((GuiEventListener)new DuelSettingButton(settingsX, settingsY, settingButtonWidth, 22, itemId, displayName)));
                settingsY += 27;
            }
            ++index;
        }
        this.m_142416_((GuiEventListener)new CustomReadyButton(this.leftPos + 15, this.topPos + this.guiHeight - 35, 150, 20));
        CustomCloseButton closeBtn = new CustomCloseButton(this.leftPos + this.guiWidth - 25, this.topPos + 5, 20, 20);
        closeBtn.f_93623_ = !this.isCountdownActive();
        this.m_142416_((GuiEventListener)closeBtn);
        this.updateWidgetVisibility();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (((List)ServerConfig.BANNED_ITEMS.get()).size() > 6 && this.currentTab == Tab.SETTINGS) {
            this.scrollY = Mth.m_14045_((int)(this.scrollY - (int)delta), (int)0, (int)(((List)ServerConfig.BANNED_ITEMS.get()).size() - 6));
            this.m_7856_();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateArenaData(List<S2C_ArenaListPacket.ArenaInfo> data, boolean canSelectArena) {
        this.arenaData = data;
        this.canSelectArena = canSelectArena;
        this.m_7856_();
    }

    private void updateWidgetVisibility() {
        this.settingButtons.values().forEach(button -> {
            button.f_93624_ = this.currentTab == Tab.SETTINGS;
        });
    }

    public void updateState(DuelSettings settings, boolean localReady, boolean opponentReady) {
        this.currentSettings = settings;
        this.localPlayerReady = localReady;
        this.opponentReady = opponentReady;
        this.setSettingsButtonsActive(!this.localPlayerReady && !this.opponentReady);
    }

    public void showCountdown(String title, int durationTicks) {
        this.countdownTitle = title;
        this.countdownStartTime = System.currentTimeMillis();
        this.countdownDuration = durationTicks * 50;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.guiWidth, this.guiHeight, this.guiWidth, this.guiHeight);
        RenderSystem.disableBlend();
        switch (this.currentTab) {
            case OVERVIEW: {
                this.renderOverviewTab(graphics, mouseX, mouseY);
                break;
            }
            case SELF_INVENTORY: {
                this.renderInventoryTab(graphics, (LivingEntity)this.localPlayer, (NonNullList<ItemStack>)this.localPlayer.m_150109_().f_35974_, (NonNullList<ItemStack>)this.localPlayer.m_150109_().f_35975_, this.getLocalPlayerCurios(), mouseX, mouseY);
                break;
            }
            case OPPONENT_INVENTORY: {
                Player opponentEntity = this.f_96541_.f_91073_.m_46003_(this.opponentUUID);
                if (opponentEntity == null) {
                    opponentEntity = this.localPlayer;
                }
                this.renderInventoryTab(graphics, (LivingEntity)opponentEntity, this.opponentMainInventory, this.opponentArmorInventory, this.opponentCuriosInventory, mouseX, mouseY);
                break;
            }
            case SETTINGS: {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u0443\u044d\u043b\u0438").m_130940_(ChatFormatting.WHITE), this.contentX + this.contentWidth / 2, this.contentY, 0xFFFFFF);
            }
        }
        for (AbstractWidget widget : this.f_169369_.stream().filter(w -> w instanceof CustomCloseButton).map(w -> (AbstractWidget)w).toList()) {
            widget.f_93623_ = !this.isCountdownActive();
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderCountdown(graphics);
    }

    private void renderArenaTab(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0410\u0440\u0435\u043d\u0443").m_130940_(ChatFormatting.WHITE), this.contentX + this.contentWidth / 2, this.contentY, 0xFFFFFF);
        if (this.arenaData.isEmpty()) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0430\u0440\u0435\u043d."), this.contentX + this.contentWidth / 2, this.contentY + this.contentHeight / 2, 0xFFFFFF);
            return;
        }
        int arenaItemHeight = 22;
        int maxVisibleArenas = (this.contentHeight - 20) / 26;
        graphics.m_280588_(this.contentX, this.contentY + 20, this.contentX + this.contentWidth, this.contentY + this.contentHeight);
        int itemY = this.contentY + 20;
        for (int i = 0; i < this.arenaData.size(); ++i) {
            S2C_ArenaListPacket.ArenaInfo arenaInfo = this.arenaData.get(i);
            int itemX = this.contentX + 5;
            graphics.m_280509_(itemX, itemY + i * 22, itemX + this.contentWidth - 10, itemY + (i + 1) * 22, 0x40000000);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)arenaInfo.name()).m_130940_(ChatFormatting.WHITE), itemX + 5, itemY + 4 + i * 22, 0xFFFFFF);
            MutableComponent statusText = arenaInfo.isOccupied() ? Component.m_237113_((String)"\u0417\u0430\u043d\u044f\u0442\u0430").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u0430").m_130940_(ChatFormatting.GREEN);
            graphics.m_280430_(this.f_96547_, (Component)statusText, itemX + 100, itemY + 4 + i * 22, 0xFFFFFF);
            itemY += 4;
        }
        graphics.m_280618_();
    }

    private void renderCountdown(GuiGraphics graphics) {
        if (this.countdownTitle.isEmpty() || System.currentTimeMillis() >= this.countdownStartTime + (long)this.countdownDuration) {
            return;
        }
        long timeElapsed = System.currentTimeMillis() - this.countdownStartTime;
        int fadeInTime = 250;
        int fadeOutTime = 500;
        float alpha = timeElapsed < (long)fadeInTime ? (float)timeElapsed / (float)fadeInTime : (timeElapsed > (long)(this.countdownDuration - fadeOutTime) ? 1.0f - (float)(timeElapsed - (long)(this.countdownDuration - fadeOutTime)) / (float)fadeOutTime : 1.0f);
        if ((alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f)) <= 0.0f) {
            this.countdownTitle = "";
            return;
        }
        int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.countdownTitle), this.leftPos + this.guiWidth - 30, this.topPos + this.guiHeight - 30, color);
    }

    private void renderOverviewTab(GuiGraphics graphics, int mouseX, int mouseY) {
        int halfContentWidth = this.contentWidth / 2;
        int selfPanelX = this.contentX;
        int opponentPanelX = this.contentX + halfContentWidth;
        this.renderPlayerInfo(graphics, "\u0412\u044b", (LivingEntity)this.localPlayer, this.localPlayerReady, selfPanelX, halfContentWidth, mouseX, mouseY);
        Player opponentEntity = this.f_96541_.f_91073_.m_46003_(this.opponentUUID);
        if (opponentEntity == null) {
            opponentEntity = this.localPlayer;
        }
        this.renderPlayerInfo(graphics, "\u0421\u043e\u043f\u0435\u0440\u043d\u0438\u043a", (LivingEntity)opponentEntity, this.opponentReady, opponentPanelX, halfContentWidth, mouseX, mouseY);
        int rulesY = this.topPos + 15;
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430:").m_130940_(ChatFormatting.YELLOW), this.leftPos + 15, rulesY, 0xFFFFFF);
        String keepInvText = "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f: ";
        MutableComponent keepInvStatus = this.currentSettings.isKeepInventory() ? Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)keepInvText).m_7220_((Component)keepInvStatus), this.leftPos + 15, rulesY + 12, 0xFFFFFF);
        int bannedCount = this.currentSettings.getBannedItemsAndTags().size();
        MutableComponent bannedItemsText = Component.m_237113_((String)"\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: ").m_7220_((Component)Component.m_237113_((String)String.valueOf(bannedCount)).m_130940_(ChatFormatting.AQUA));
        graphics.m_280430_(this.f_96547_, (Component)bannedItemsText, this.leftPos + 15, rulesY + 24, 0xFFFFFF);
    }

    private void renderPlayerInfo(GuiGraphics graphics, String name, LivingEntity playerToRender, boolean isReady, int panelX, int panelWidth, int mouseX, int mouseY) {
        int panelCenterX = panelX + panelWidth / 2;
        int infoY = this.contentY + 70;
        int modelY = infoY + 100;
        int modelSize = 65;
        MutableComponent statusText = isReady ? Component.m_237113_((String)"\u0413\u043e\u0442\u043e\u0432").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u041d\u0435 \u0433\u043e\u0442\u043e\u0432").m_130940_(ChatFormatting.RED);
        graphics.m_280653_(this.f_96547_, (Component)statusText, panelCenterX, modelY + 12, 0xFFFFFF);
        int wins = name.equals("\u0412\u044b") ? this.selfWins : this.opponentWins;
        int losses = name.equals("\u0412\u044b") ? this.selfLosses : this.opponentLosses;
        double winRate = wins + losses > 0 ? (double)wins / (double)(wins + losses) * 100.0 : 0.0;
        MutableComponent statsText = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)String.valueOf(wins)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.valueOf(losses)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)String.format(" (%.1f%%)", winRate)).m_130940_(ChatFormatting.YELLOW));
        graphics.m_280653_(this.f_96547_, (Component)statsText, panelCenterX, modelY + 24, 0xFFFFFF);
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)panelCenterX, (int)modelY, (int)modelSize, (float)(panelCenterX - mouseX), (float)(modelY - 50 - mouseY), (LivingEntity)playerToRender);
    }

    private void renderInventoryTab(GuiGraphics graphics, LivingEntity playerToRender, NonNullList<ItemStack> mainInv, NonNullList<ItemStack> armorInv, NonNullList<ItemStack> curiosInv, int mouseX, int mouseY) {
        int row;
        int i;
        int invCenterX = this.contentX + this.contentWidth / 2;
        int invCenterY = this.contentY + this.contentHeight / 2 - 10;
        int invStartX = invCenterX - 81;
        int armorTopY = invCenterY - 60;
        int mainInvTopY = armorTopY + 25 - 7;
        int curiosTopY = mainInvTopY + 83;
        int armorX = invCenterX - 36;
        int curiosRowWidth = 108;
        int curiosStartX = invCenterX - curiosRowWidth / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(ARMOR_SLOTS_TEXTURE, armorX, armorTopY - 14, 0.0f, 0.0f, 72, 18, 72, 18);
        graphics.m_280163_(INVENTORY_SLOTS_TEXTURE, invStartX - 5, mainInvTopY - 7, 0.0f, 0.0f, 172, 83, 172, 83);
        graphics.m_280163_(INVENTORY_SLOTS_TEXTURE, curiosStartX, curiosTopY, 0.0f, 0.0f, curiosRowWidth, 38, 108, 38);
        RenderSystem.disableBlend();
        for (i = 0; i < 4; ++i) {
            graphics.m_280203_((ItemStack)armorInv.get(3 - i), armorX + i * 18, armorTopY - 14);
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                graphics.m_280203_((ItemStack)mainInv.get(9 + row * 9 + col), invStartX + col * 18, mainInvTopY - 2 + row * 18);
            }
        }
        for (i = 0; i < 9; ++i) {
            graphics.m_280203_((ItemStack)mainInv.get(i), invStartX + i * 18, mainInvTopY + 56);
        }
        for (i = 0; i < Math.min(curiosInv.size(), 12); ++i) {
            int row2 = i / 6;
            int col = i % 6;
            graphics.m_280203_((ItemStack)curiosInv.get(i), curiosStartX + col * 18 + 1, curiosTopY + row2 * 20 + 1);
        }
        for (i = 0; i < 4; ++i) {
            ItemStack stack = (ItemStack)armorInv.get(3 - i);
            if (stack.m_41619_() || !this.isHovering(armorX + i * 18, armorTopY - 14, mouseX, mouseY)) continue;
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                ItemStack stack = (ItemStack)mainInv.get(9 + row * 9 + col);
                if (stack.m_41619_() || !this.isHovering(invStartX + col * 18, mainInvTopY - 2 + row * 18, mouseX, mouseY)) continue;
                graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
            }
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)mainInv.get(i);
            if (stack.m_41619_() || !this.isHovering(invStartX + i * 18, mainInvTopY + 56, mouseX, mouseY)) continue;
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
        for (i = 0; i < Math.min(curiosInv.size(), 12); ++i) {
            ItemStack stack = (ItemStack)curiosInv.get(i);
            int row3 = i / 6;
            int col = i % 6;
            if (stack.m_41619_() || !this.isHovering(curiosStartX + col * 18, curiosTopY + row3 * 20, mouseX, mouseY)) continue;
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
        int rulesY = this.topPos + 15;
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430:").m_130940_(ChatFormatting.YELLOW), this.leftPos + 15, rulesY, 0xFFFFFF);
        String keepInvText = "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f: ";
        MutableComponent keepInvStatus = this.currentSettings.isKeepInventory() ? Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)keepInvText).m_7220_((Component)keepInvStatus), this.leftPos + 15, rulesY + 12, 0xFFFFFF);
        int bannedCount = this.currentSettings.getBannedItemsAndTags().size();
        MutableComponent bannedItemsText = Component.m_237113_((String)"\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: ").m_7220_((Component)Component.m_237113_((String)String.valueOf(bannedCount)).m_130940_(ChatFormatting.AQUA));
        graphics.m_280430_(this.f_96547_, (Component)bannedItemsText, this.leftPos + 15, rulesY + 24, 0xFFFFFF);
    }

    private NonNullList<ItemStack> getLocalPlayerCurios() {
        if (!ModList.get().isLoaded("curios")) {
            return NonNullList.m_122779_();
        }
        NonNullList curios = NonNullList.m_122779_();
        CuriosApi.getCuriosInventory((LivingEntity)this.localPlayer).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                curios.add((Object)stacksHandler.getStacks().getStackInSlot(i));
            }
        }));
        return curios;
    }

    private boolean isHovering(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
    }

    private void setSettingsButtonsActive(boolean active) {
        this.settingButtons.values().forEach(button -> {
            button.f_93623_ = active;
        });
    }

    private boolean isCountdownActive() {
        return !this.countdownTitle.isEmpty() && System.currentTimeMillis() < this.countdownStartTime + (long)this.countdownDuration;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private static enum Tab {
        OVERVIEW,
        SELF_INVENTORY,
        OPPONENT_INVENTORY,
        SETTINGS;

    }

    private class TabButton
    extends Button {
        private final Tab tab;

        public TabButton(int x, int y, int width, String text, Tab tab) {
            super(x, y, width, 20, (Component)Component.m_237113_((String)text), btn -> {
                ua$omega$omegaduels$client$gui$DuelPrepScreen$this.currentTab = tab;
                DuelPrepScreen.this.updateWidgetVisibility();
            }, f_252438_);
            this.tab = tab;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int textColor;
            int n = textColor = DuelPrepScreen.this.currentTab == this.tab ? -1 : -5592406;
            if (this.m_198029_()) {
                textColor = -96;
            }
            graphics.m_280430_(DuelPrepScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + 8, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }

    private class DuelSettingButton
    extends Button {
        private final String settingId;
        private final String label;

        public DuelSettingButton(int x, int y, int width, int height, String settingId, String label) {
            super(x, y, width, height, (Component)Component.m_237119_(), btn -> {}, f_252438_);
            this.settingId = settingId;
            this.label = label;
        }

        public void m_5691_() {
            if (!this.f_93623_) {
                return;
            }
            if (this.settingId.equals("keepInventory")) {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_UpdateDuelSettingPacket(this.settingId, !DuelPrepScreen.this.currentSettings.isKeepInventory()));
            } else {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_UpdateDuelSettingPacket(this.settingId, DuelPrepScreen.this.currentSettings.getBannedItemsAndTags().contains(this.settingId)));
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int valueColor;
            boolean enabled = this.settingId.equals("keepInventory") ? DuelPrepScreen.this.currentSettings.isKeepInventory() : !DuelPrepScreen.this.currentSettings.getBannedItemsAndTags().contains(this.settingId);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (!this.f_93623_) {
                r = 0.5f;
                g = 0.5f;
                b = 0.5f;
            } else if (!this.m_198029_()) {
                r = 0.8f;
                g = 0.8f;
                b = 0.8f;
            }
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            RenderSystem.enableBlend();
            graphics.m_280163_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_() + 10, this.m_93694_(), this.m_5711_() + 10, this.m_93694_());
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int n = valueColor = enabled ? -13710223 : -1618884;
            String valueText = enabled ? (this.settingId.equals("keepInventory") ? "\u2714" : "\u2714") : (this.settingId.equals("keepInventory") ? "\u274c" : "\u274c");
            graphics.m_280056_(DuelPrepScreen.this.f_96547_, this.label, this.m_252754_() + 8, this.m_252907_() + (this.f_93619_ - 8) / 2, this.f_93623_ ? -1249039 : -7829368, false);
            graphics.m_280056_(DuelPrepScreen.this.f_96547_, valueText, this.m_252754_() + this.m_5711_() - DuelPrepScreen.this.f_96547_.m_92895_(valueText), this.m_252907_() + (this.f_93619_ - 8) / 2, this.f_93623_ ? valueColor : -7829368, false);
        }
    }

    private class CustomReadyButton
    extends Button {
        public CustomReadyButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), btn -> {}, f_252438_);
        }

        public void m_5691_() {
            if (!this.f_93623_) {
                return;
            }
            if (DuelPrepScreen.this.localPlayerReady) {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_CancelReadyPacket());
            } else {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_PlayerReadyPacket());
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            MutableComponent text = DuelPrepScreen.this.localPlayerReady ? Component.m_237113_((String)"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c") : Component.m_237113_((String)"\u0413\u043e\u0442\u043e\u0432");
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (DuelPrepScreen.this.localPlayerReady) {
                r = 1.0f;
                g = 0.6f;
                b = 0.6f;
            } else {
                r = 0.6f;
                g = 1.0f;
                b = 0.6f;
            }
            if (!this.f_93623_) {
                r = 0.5f;
                g = 0.5f;
                b = 0.5f;
            } else if (this.m_198029_()) {
                r = 1.0f;
                g = 1.0f;
                b = 0.7f;
            }
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            graphics.m_280163_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280653_(DuelPrepScreen.this.f_96547_, (Component)text, this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + (this.m_93694_() - 8) / 2, this.f_93623_ ? -1 : -5592406);
        }
    }

    private class CustomCloseButton
    extends Button {
        public CustomCloseButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237113_((String)"x"), btn -> {}, f_252438_);
        }

        public void m_5691_() {
            PacketHandler.INSTANCE.sendToServer((Object)new C2S_CancelDuelPacket());
            Minecraft.m_91087_().m_91152_(null);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int color = this.m_198029_() ? -1 : -5592406;
            graphics.m_280653_(DuelPrepScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, color);
        }
    }

    private class ArenaButton
    extends Button {
        private final String arenaName;
        private final boolean isOccupied;
        private final boolean canSelect;

        public ArenaButton(int x, int y, int width, int height, String arenaName, boolean isOccupied) {
            super(x, y, width, height, (Component)Component.m_237113_((String)arenaName), btn -> {}, f_252438_);
            this.arenaName = arenaName;
            this.isOccupied = isOccupied;
            this.canSelect = DuelPrepScreen.this.canSelectArena;
            this.f_93623_ = !isOccupied && this.canSelect;
        }

        public void m_5691_() {
            if (this.f_93623_) {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_SelectArenaPacket(this.arenaName));
                Minecraft.m_91087_().m_91152_(null);
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int color;
            MutableComponent nameComponent = Component.m_237113_((String)this.arenaName).m_130940_(ChatFormatting.WHITE);
            MutableComponent statusComponent = this.isOccupied ? Component.m_237113_((String)"\u0417\u0430\u043d\u044f\u0442\u0430").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u0430").m_130940_(ChatFormatting.GREEN);
            int n = color = this.f_93623_ ? -1 : -5592406;
            if (this.m_198029_()) {
                color = this.f_93623_ ? -96 : -7829368;
            }
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), 0x40000000);
            graphics.m_280614_(DuelPrepScreen.this.f_96547_, (Component)nameComponent, this.m_252754_() + 5, this.m_252907_() + 4, color, false);
            graphics.m_280614_(DuelPrepScreen.this.f_96547_, (Component)statusComponent, this.m_252754_() + this.m_5711_() - DuelPrepScreen.this.f_96547_.m_92852_((FormattedText)statusComponent) - 5, this.m_252907_() + 4, color, false);
            if (this.m_198029_() && !this.f_93623_) {
                MutableComponent tooltip = this.isOccupied ? Component.m_237113_((String)"\u042d\u0442\u0430 \u0430\u0440\u0435\u043d\u0430 \u0437\u0430\u043d\u044f\u0442\u0430").m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)"\u0414\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0430\u0440\u0435\u043d\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0434\u043e\u043d\u0430\u0442").m_130940_(ChatFormatting.RED);
                graphics.m_280557_(DuelPrepScreen.this.f_96547_, (Component)tooltip, mouseX, mouseY);
            }
        }
    }
}

