/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ua.omega.omegaduels.client.keybinding.KeyBindingManager;

@OnlyIn(value=Dist.CLIENT)
public class DuelToastGui {
    private static final ResourceLocation TOAST_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/toast.png");
    private String requesterName = "";
    private long startTime = 0L;
    private final int DURATION = 15000;

    public void show(String requesterName) {
        this.requesterName = requesterName;
        this.startTime = System.currentTimeMillis();
    }

    public boolean isActive() {
        return !this.requesterName.isEmpty() && System.currentTimeMillis() < this.startTime + 15000L;
    }

    public String getRequesterName() {
        return this.requesterName;
    }

    public void clear() {
        this.requesterName = "";
        this.startTime = 0L;
    }

    public void render(GuiGraphics graphics) {
        float animationDuration;
        if (!this.isActive()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int width = 180;
        int height = 50;
        long timeElapsed = System.currentTimeMillis() - this.startTime;
        float progress = (float)timeElapsed / 15000.0f;
        float slideProgress = progress < (animationDuration = 0.05f) ? Mth.m_14179_((float)(progress / animationDuration), (float)0.0f, (float)1.0f) : (progress > 1.0f - animationDuration ? Mth.m_14179_((float)((progress - (1.0f - animationDuration)) / animationDuration), (float)1.0f, (float)0.0f) : 1.0f);
        int x = (int)((float)screenWidth - (float)width * slideProgress);
        int y = screenHeight / 4;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(TOAST_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        MutableComponent title = Component.m_237113_((String)"\u0412\u044b\u0437\u043e\u0432 \u043d\u0430 \u0434\u0443\u044d\u043b\u044c!");
        MutableComponent subtitle = Component.m_237113_((String)("\u043e\u0442 " + this.requesterName));
        MutableComponent actions = Component.m_237113_((String)String.format("[%s] \u041f\u0440\u0438\u043d\u044f\u0442\u044c / [%s] \u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c", KeyBindingManager.DUEL_ACCEPT_KEY.m_90863_().getString().toUpperCase(), KeyBindingManager.DUEL_DECLINE_KEY.m_90863_().getString().toUpperCase()));
        graphics.m_280614_(mc.f_91062_, (Component)title, x + 10, y + 8, -96, true);
        graphics.m_280614_(mc.f_91062_, (Component)subtitle, x + 10, y + 18, -1, true);
        graphics.m_280614_(mc.f_91062_, (Component)actions, x + 10, y + 32, -5592406, false);
        int timerWidth = (int)((1.0f - progress) * (float)(width - 20));
        graphics.m_280509_(x + 10, y + height - 8, x + 10 + timerWidth, y + height - 6, -96);
    }
}

