/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class MatchToastGui {
    private static final ResourceLocation TOAST_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/toast.png");
    private long startTime = 0L;
    private int duration = 0;
    private String player1Name = "";
    private String player2Name = "";

    public void show(String p1Name, String p2Name, int countdownSeconds) {
        this.player1Name = p1Name;
        this.player2Name = p2Name;
        this.startTime = System.currentTimeMillis();
        this.duration = countdownSeconds * 1000;
    }

    public boolean isActive() {
        return this.startTime != 0L && System.currentTimeMillis() < this.startTime + (long)this.duration;
    }

    public void clear() {
        this.startTime = 0L;
    }

    public void render(GuiGraphics graphics) {
        if (!this.isActive()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int width = 180;
        int height = 50;
        long timeElapsed = System.currentTimeMillis() - this.startTime;
        float progress = (float)timeElapsed / (float)this.duration;
        int x = screenWidth - width - 10;
        int y = 10;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(TOAST_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        int remainingSeconds = (int)Math.ceil((double)((long)this.duration - timeElapsed) / 1000.0);
        MutableComponent title = Component.m_237113_((String)"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0431\u043e\u0439!");
        MutableComponent players = Component.m_237113_((String)(this.player1Name + " vs " + this.player2Name));
        MutableComponent countdown = Component.m_237113_((String)("\u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437: " + remainingSeconds + "\u0441"));
        graphics.m_280614_(mc.f_91062_, (Component)title, x + 10, y + 8, -96, true);
        graphics.m_280614_(mc.f_91062_, (Component)players, x + 10, y + 18, -1, true);
        graphics.m_280614_(mc.f_91062_, (Component)countdown, x + 10, y + 32, -5592406, false);
        int timerWidth = (int)((1.0f - progress) * (float)(width - 20));
        graphics.m_280509_(x + 10, y + height - 8, x + 10 + timerWidth, y + height - 6, -96);
    }
}

