/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import ua.omega.omegaduels.client.keybinding.KeyBindingManager;

public class PlayerTargetGui {
    private static final ResourceLocation TEXTURE = new ResourceLocation("omegaduels", "textures/gui/toast.png");
    private static final int BASE_WIDTH = 120;
    private static final int BASE_HEIGHT = 25;
    private static final float ANIMATION_SPEED = 5.0f;
    private float scale = 1.0f;
    private float animationProgress = 0.0f;
    private boolean targetStateIsVisible = false;
    private long lastFrameTime = 0L;

    public void show() {
        this.targetStateIsVisible = true;
    }

    public void hide() {
        this.targetStateIsVisible = false;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    private float easeOutQuint(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 5.0);
    }

    public void render(GuiGraphics graphics) {
        long currentTime = System.currentTimeMillis();
        if (this.lastFrameTime == 0L) {
            this.lastFrameTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = currentTime;
        this.animationProgress = this.targetStateIsVisible ? Math.min(1.0f, this.animationProgress + 5.0f * deltaTime) : Math.max(0.0f, this.animationProgress - 5.0f * deltaTime);
        if (this.animationProgress <= 0.0f || this.scale <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        float autoScale = Math.min(1.0f, Math.min((float)screenWidth / 400.0f, (float)screenHeight / 300.0f));
        float finalScale = autoScale * this.scale;
        float scaledWidth = 120.0f * finalScale;
        float scaledHeight = 25.0f * finalScale;
        float x = (float)screenWidth / 2.0f - scaledWidth / 2.0f;
        float easedProgress = this.easeOutQuint(this.animationProgress);
        float finalY = scaledHeight - 20.0f;
        float startY = -scaledHeight;
        float y = startY + (finalY - startY) * easedProgress;
        float alpha = easedProgress * 0.9f;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(finalScale, finalScale, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(TEXTURE, 0, 0, 0.0f, 0.0f, 120, 25, 120, 25);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MutableComponent text = Component.m_237113_((String)"\u0412\u044b\u0437\u0432\u0430\u0442\u044c \u043d\u0430 \u0434\u0443\u044d\u043b\u044c: ");
        MutableComponent keybind = KeyBindingManager.DUEL_REQUEST_KEY.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW);
        int baseColor = 0xFFFFFF;
        int alphaComponent = (int)(easedProgress * 255.0f) << 24;
        int animatedColor = alphaComponent | baseColor;
        int textX = 8;
        Objects.requireNonNull(mc.f_91062_);
        int textY = (int)((float)(25 - 9) / 2.0f + 2.0f);
        graphics.m_280614_(mc.f_91062_, (Component)text.m_6881_().m_7220_((Component)keybind), textX, textY - 1, animatedColor, false);
        poseStack.m_85849_();
    }
}

