/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import ua.omega.omegaduels.network.packets.S2C_TournamentRoundUpdatePacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentUpdatePacket;

public class TournamentScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/background.png");
    private static final ResourceLocation PLAYER_PLATE_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/armor.png");
    private Tab currentTab = Tab.BRACKET;
    private S2C_TournamentUpdatePacket tournamentData;
    private final Map<UUID, S2C_TournamentUpdatePacket.ParticipantInfo> participantMap = new HashMap<UUID, S2C_TournamentUpdatePacket.ParticipantInfo>();
    private int guiWidth;
    private int guiHeight;
    private int leftPos;
    private int topPos;
    private int contentX;
    private int contentY;
    private int contentWidth;
    private int contentHeight;
    private double zoom = 1.0;
    private static final double MIN_ZOOM = 0.5;
    private static final double MAX_ZOOM = 2.0;
    private double panX = 0.0;
    private double panY = 0.0;
    private boolean isDragging = false;
    private double lastMouseX;
    private double lastMouseY;

    public TournamentScreen(S2C_TournamentUpdatePacket msg) {
        super((Component)Component.m_237113_((String)"Tournament"));
        this.updateState(msg);
    }

    public void updateState(S2C_TournamentUpdatePacket msg) {
        this.tournamentData = msg;
        this.participantMap.clear();
        if (msg != null && msg.getParticipants() != null) {
            for (S2C_TournamentUpdatePacket.ParticipantInfo p : msg.getParticipants()) {
                this.participantMap.put(p.getUuid(), p);
            }
        }
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            this.m_7856_();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiWidth = 600;
        this.guiHeight = 340;
        if (this.f_96543_ < this.guiWidth) {
            this.guiWidth = this.f_96543_ - 40;
        }
        if (this.f_96544_ < this.guiHeight) {
            this.guiHeight = this.f_96544_ - 40;
        }
        this.leftPos = (this.f_96543_ - this.guiWidth) / 2;
        this.topPos = (this.f_96544_ - this.guiHeight) / 2;
        int tabWidth = 130;
        int tabHeight = 20;
        int tabsStartX = this.leftPos + 5;
        int tabsStartY = this.topPos + 10;
        this.contentX = tabsStartX + 130 + 10;
        this.contentWidth = this.guiWidth - 130 - 25;
        this.contentY = this.topPos + 10;
        this.contentHeight = this.guiHeight - 20;
        this.m_142416_((GuiEventListener)new TabButton(tabsStartX, tabsStartY, 130, "\u0421\u0435\u0442\u043a\u0430 \u0422\u0443\u0440\u043d\u0438\u0440\u0430", Tab.BRACKET));
        this.m_142416_((GuiEventListener)new TabButton(tabsStartX, tabsStartY + 20 + 4, 130, "\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0438", Tab.PARTICIPANTS));
        this.m_142416_((GuiEventListener)new TabButton(tabsStartX, tabsStartY + 48, 130, "\u041d\u0430\u0431\u043e\u0440", Tab.KIT));
        this.resetAndCenterBracket();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.guiWidth, this.guiHeight, this.guiWidth, this.guiHeight);
        RenderSystem.disableBlend();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        switch (this.currentTab) {
            case BRACKET: {
                graphics.m_280588_(this.contentX, this.contentY, this.contentX + this.contentWidth, this.contentY + this.contentHeight);
                this.renderBracketTab(graphics);
                graphics.m_280618_();
                break;
            }
            case PARTICIPANTS: {
                this.renderParticipantsTab(graphics);
                break;
            }
            case KIT: {
                this.renderKitTab(graphics, mouseX, mouseY);
            }
        }
    }

    private void renderBracketTab(GuiGraphics graphics) {
        if (this.tournamentData == null || this.tournamentData.getBracketInfo() == null || this.tournamentData.getBracketInfo().getRounds().isEmpty()) {
            graphics.m_280137_(this.f_96547_, "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0442\u0443\u0440\u043d\u0438\u0440\u0430...", this.contentX + this.contentWidth / 2, this.contentY + this.contentHeight / 2, 0xFFFFFF);
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.contentX, (float)this.contentY, 0.0f);
        graphics.m_280168_().m_85837_(this.panX, this.panY, 0.0);
        graphics.m_280168_().m_85841_((float)this.zoom, (float)this.zoom, 1.0f);
        S2C_TournamentUpdatePacket.BracketInfo bracket = this.tournamentData.getBracketInfo();
        Map<UUID, String> playerNames = this.participantMap.values().stream().collect(Collectors.toMap(S2C_TournamentUpdatePacket.ParticipantInfo::getUuid, S2C_TournamentUpdatePacket.ParticipantInfo::getName));
        int playerPlateWidth = 100;
        int playerPlateHeight = 18;
        int horizontalGap = 40;
        int verticalPlayerGap = 4;
        int matchBlockHeight = 40;
        HashMap prevRoundYCenters = new HashMap();
        for (int r = 0; r < bracket.getRounds().size(); ++r) {
            List<S2C_TournamentUpdatePacket.MatchInfo> roundMatches = bracket.getRounds().get(r);
            int roundX = r * 140;
            HashMap<Integer, Integer> currentRoundYCenters = new HashMap<Integer, Integer>();
            for (int m = 0; m < roundMatches.size(); ++m) {
                S2C_TournamentUpdatePacket.MatchInfo match = roundMatches.get(m);
                int matchCenterY = r == 0 ? m * 60 + 20 : (Integer)prevRoundYCenters.get(m * 2) + ((Integer)prevRoundYCenters.get(m * 2 + 1) - (Integer)prevRoundYCenters.get(m * 2)) / 2;
                currentRoundYCenters.put(m, matchCenterY);
                int p1y = matchCenterY - 20;
                int p2y = p1y + 18 + 4;
                this.drawPlayerPlate(graphics, match.getP1(), playerNames, roundX, p1y, match.getWinner());
                this.drawPlayerPlate(graphics, match.getP2(), playerNames, roundX, p2y, match.getWinner());
                if (r <= 0) continue;
                int parent1Y = (Integer)prevRoundYCenters.get(m * 2);
                int parent2Y = (Integer)prevRoundYCenters.get(m * 2 + 1);
                int lineConnectorX = roundX - 20;
                int prevRoundX = (r - 1) * 140;
                int prevRoundLineEndX = prevRoundX + 100;
                graphics.m_280315_(lineConnectorX, Math.min(parent1Y, parent2Y), Math.max(parent1Y, parent2Y), -8355712);
                graphics.m_280656_(prevRoundLineEndX, lineConnectorX, parent1Y, -8355712);
                graphics.m_280656_(prevRoundLineEndX, lineConnectorX, parent2Y, -8355712);
                graphics.m_280656_(lineConnectorX, roundX, matchCenterY, -8355712);
            }
            prevRoundYCenters = currentRoundYCenters;
        }
        graphics.m_280168_().m_85849_();
    }

    private void drawPlayerPlate(GuiGraphics graphics, UUID pUUID, Map<UUID, String> names, int x, int y, UUID winnerUUID) {
        String name = "BYE";
        ChatFormatting color = ChatFormatting.DARK_GRAY;
        int plateWidth = 100;
        int plateHeight = 18;
        if (pUUID != null) {
            name = names.getOrDefault(pUUID, "Unknown");
            color = ChatFormatting.WHITE;
            if (winnerUUID != null) {
                color = pUUID.equals(winnerUUID) ? ChatFormatting.GREEN : ChatFormatting.RED;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(PLAYER_PLATE_TEXTURE, x, y, 0.0f, 0.0f, plateWidth, plateHeight, plateWidth, plateHeight);
        RenderSystem.disableBlend();
        String truncatedName = this.f_96547_.m_92834_(name, plateWidth - 10);
        MutableComponent mutableComponent = Component.m_237113_((String)truncatedName).m_130940_(color);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, (Component)mutableComponent, x + 5, y + (plateHeight - 9) / 2 + 1, 0xFFFFFF, false);
    }

    private void renderParticipantsTab(GuiGraphics graphics) {
        graphics.m_280137_(this.f_96547_, "\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0438 \u0422\u0443\u0440\u043d\u0438\u0440\u0430", this.contentX + this.contentWidth / 2, this.contentY + 5, 0xFFFFFF);
        if (this.tournamentData == null || this.tournamentData.getParticipants() == null) {
            return;
        }
        int participantCount = this.tournamentData.getParticipants().size();
        int yPos = this.contentY + 25;
        MutableComponent countComponent = Component.m_237113_((String)"\u0412\u0441\u0435\u0433\u043e \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.valueOf(participantCount)).m_130940_(ChatFormatting.GOLD));
        graphics.m_280430_(this.f_96547_, (Component)countComponent, this.contentX + 10, yPos, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u0422\u043e\u043f-5 \u043f\u043e \u0440\u0435\u0439\u0442\u0438\u043d\u0433\u0443 ELO:").m_130940_(ChatFormatting.AQUA), this.contentX + 10, yPos += 20, 0xFFFFFF);
        yPos += 12;
        List<S2C_TournamentUpdatePacket.ParticipantInfo> top5 = this.tournamentData.getParticipants().stream().sorted(Comparator.comparingInt(S2C_TournamentUpdatePacket.ParticipantInfo::getElo).reversed()).limit(5L).toList();
        int rank = 1;
        for (S2C_TournamentUpdatePacket.ParticipantInfo p : top5) {
            if (yPos + 12 > this.contentY + this.contentHeight) break;
            MutableComponent text = Component.m_237113_((String)(rank + ". " + p.getName())).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(" (ELO: " + p.getElo() + ")")).m_130940_(ChatFormatting.GRAY));
            graphics.m_280430_(this.f_96547_, (Component)text, this.contentX + 15, yPos, 0xFFFFFF);
            yPos += 12;
            ++rank;
        }
    }

    private void renderKitTab(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.tournamentData == null) {
            return;
        }
        graphics.m_280137_(this.f_96547_, "\u041d\u0430\u0431\u043e\u0440 \u0442\u0443\u0440\u043d\u0438\u0440\u0430: " + this.tournamentData.getKitName(), this.contentX + this.contentWidth / 2, this.contentY + 5, 0xFFFFFF);
        List<ItemStack> kitItems = this.tournamentData.getKitItems();
        if (kitItems.isEmpty()) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u041d\u0430\u0431\u043e\u0440 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d.").m_130940_(ChatFormatting.GRAY), this.contentX + this.contentWidth / 2, this.contentY + 30, 0xFFFFFF);
            return;
        }
        int invStartX = this.contentX + (this.contentWidth - 162) / 2;
        int invStartY = this.contentY + 30;
        for (int i = 0; i < kitItems.size() && i < 36; ++i) {
            int row = i / 9;
            int col = i % 9;
            int x = invStartX + col * 18;
            int y = invStartY + row * 18;
            ItemStack stack = kitItems.get(i);
            graphics.m_280203_(stack, x, y);
            graphics.m_280370_(this.f_96547_, stack, x, y);
            if (!this.isMouseOver(mouseX, mouseY, x, y, 16, 16)) continue;
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.currentTab == Tab.BRACKET && this.isMouseOver(mouseX, mouseY, this.contentX, this.contentY, this.contentWidth, this.contentHeight)) {
            this.isDragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.isDragging = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.isDragging) {
            this.panX += mouseX - this.lastMouseX;
            this.panY += mouseY - this.lastMouseY;
            this.clampBracketOffset();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (this.currentTab == Tab.BRACKET && this.isMouseOver(mouseX, mouseY, this.contentX, this.contentY, this.contentWidth, this.contentHeight)) {
            double oldZoom = this.zoom;
            this.zoom += deltaY * 0.1 * this.zoom;
            this.zoom = Mth.m_14008_((double)this.zoom, (double)0.5, (double)2.0);
            if (oldZoom != this.zoom) {
                double mouseRelX = mouseX - (double)this.contentX - this.panX;
                double mouseRelY = mouseY - (double)this.contentY - this.panY;
                this.panX -= mouseRelX * (this.zoom / oldZoom) - mouseRelX;
                this.panY -= mouseRelY * (this.zoom / oldZoom) - mouseRelY;
                this.clampBracketOffset();
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaY);
    }

    public void updateRound(int roundIndex, List<S2C_TournamentRoundUpdatePacket.Matchup> matchups) {
        if (this.tournamentData == null) {
            return;
        }
        if (roundIndex < this.tournamentData.getBracketInfo().getRounds().size()) {
            List<S2C_TournamentUpdatePacket.MatchInfo> round = this.tournamentData.getBracketInfo().getRounds().get(roundIndex);
            for (int i = 0; i < matchups.size() && i < round.size(); ++i) {
                S2C_TournamentRoundUpdatePacket.Matchup matchup = matchups.get(i);
                round.set(i, new S2C_TournamentUpdatePacket.MatchInfo(matchup.p1(), matchup.p2(), null));
            }
        }
    }

    public void updateMatchResult(int roundIndex, int matchIndex, UUID winnerId) {
        List<S2C_TournamentUpdatePacket.MatchInfo> round;
        if (this.tournamentData == null) {
            return;
        }
        if (roundIndex < this.tournamentData.getBracketInfo().getRounds().size() && matchIndex < (round = this.tournamentData.getBracketInfo().getRounds().get(roundIndex)).size()) {
            S2C_TournamentUpdatePacket.MatchInfo matchInfo = round.get(matchIndex);
            S2C_TournamentUpdatePacket.MatchInfo updatedMatch = new S2C_TournamentUpdatePacket.MatchInfo(matchInfo.getP1(), matchInfo.getP2(), winnerId);
            round.set(matchIndex, updatedMatch);
        }
    }

    private void resetAndCenterBracket() {
        this.panX = 0.0;
        this.panY = 0.0;
        this.zoom = 1.0;
        this.clampBracketOffset();
    }

    private void clampBracketOffset() {
        double minPanY;
        double maxPanY;
        double minPanX;
        double maxPanX;
        if (this.tournamentData == null || this.tournamentData.getBracketInfo() == null || this.tournamentData.getBracketInfo().getRounds().isEmpty()) {
            this.panX = 0.0;
            this.panY = 0.0;
            return;
        }
        S2C_TournamentUpdatePacket.BracketInfo bracket = this.tournamentData.getBracketInfo();
        int plateW = 100;
        int plateH = 18;
        int hGap = 40;
        int vGap = 4;
        int matchH = 40;
        double bracketW = bracket.getRounds().size() * 140 - 40;
        double bracketH = (double)bracket.getRounds().get(0).size() * 60.0 - 20.0;
        double scaledW = bracketW * this.zoom;
        double scaledH = bracketH * this.zoom;
        if (scaledW <= (double)this.contentWidth) {
            minPanX = maxPanX = ((double)this.contentWidth - scaledW) / 2.0;
        } else {
            minPanX = (double)this.contentWidth - scaledW;
            maxPanX = 0.0;
        }
        if (scaledH <= (double)this.contentHeight) {
            minPanY = maxPanY = ((double)this.contentHeight - scaledH) / 2.0;
        } else {
            minPanY = (double)this.contentHeight - scaledH;
            maxPanY = 0.0;
        }
        this.panX = Mth.m_14008_((double)this.panX, (double)minPanX, (double)maxPanX);
        this.panY = Mth.m_14008_((double)this.panY, (double)minPanY, (double)maxPanY);
    }

    private boolean isMouseOver(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        BRACKET,
        PARTICIPANTS,
        KIT;

    }

    private class TabButton
    extends Button {
        private final Tab tab;

        public TabButton(int x, int y, int width, String text, Tab tab) {
            super(x, y, width, 20, (Component)Component.m_237113_((String)text), btn -> {
                ua$omega$omegaduels$client$gui$TournamentScreen$this.currentTab = tab;
                TournamentScreen.this.resetAndCenterBracket();
            }, f_252438_);
            this.tab = tab;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int textColor = -5592406;
            if (TournamentScreen.this.currentTab == this.tab) {
                textColor = -1;
            } else if (this.m_198029_()) {
                textColor = -96;
            }
            graphics.m_280653_(TournamentScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }
}

