/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TournamentStartToastGui {
    private static final ResourceLocation TOAST_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/toast.png");
    private long startTime = 0L;
    private int duration = 30000;

    public void show() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean isActive() {
        return this.startTime != 0L && System.currentTimeMillis() < this.startTime + (long)this.duration;
    }

    public void clear() {
        this.startTime = 0L;
    }

    public void render(GuiGraphics graphics) {
        if (!this.isActive()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int width = 180;
        int height = 50;
        long timeElapsed = System.currentTimeMillis() - this.startTime;
        float progress = (float)timeElapsed / (float)this.duration;
        int remainingSeconds = Math.max(0, (int)Math.ceil((double)((long)this.duration - timeElapsed) / 1000.0));
        int x = screenWidth - width - 10;
        int y = 120;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(TOAST_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        MutableComponent title = Component.m_237113_((String)"\u0422\u0443\u0440\u043d\u0438\u0440 \u0441\u043a\u043e\u0440\u043e \u043d\u0430\u0447\u043d\u0435\u0442\u0441\u044f!");
        MutableComponent countdown = Component.m_237113_((String)"\u0414\u043e \u043d\u0430\u0447\u0430\u043b\u0430: ").m_7220_((Component)Component.m_237113_((String)String.valueOf(remainingSeconds)).m_130940_(ChatFormatting.YELLOW)).m_130946_("\u0441");
        graphics.m_280614_(mc.f_91062_, (Component)title, x + 10, y + 12, -16711936, true);
        graphics.m_280614_(mc.f_91062_, (Component)countdown, x + 10, y + 28, -1, false);
        int timerWidth = (int)((1.0f - progress) * (float)(width - 20));
        graphics.m_280509_(x + 10, y + height - 8, x + 10 + timerWidth, y + height - 6, -16711936);
    }
}

