/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import ua.omega.omegaduels.client.keybinding.KeyBindingManager;

public class TournamentToastGui {
    private static final ResourceLocation TOAST_TEXTURE = new ResourceLocation("omegaduels", "textures/gui/toast.png");
    private long startTime = 0L;
    private int duration = 0;

    public void show(int timeoutSeconds) {
        this.startTime = System.currentTimeMillis();
        this.duration = timeoutSeconds * 1000;
    }

    public boolean isActive() {
        return this.startTime != 0L && System.currentTimeMillis() < this.startTime + (long)this.duration;
    }

    public void clear() {
        this.startTime = 0L;
        this.duration = 0;
    }

    public void render(GuiGraphics graphics) {
        float animationDuration;
        if (!this.isActive()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int width = 180;
        int height = 50;
        long timeElapsed = System.currentTimeMillis() - this.startTime;
        float progress = (float)timeElapsed / (float)this.duration;
        float slideProgress = progress < (animationDuration = 0.1f) ? Mth.m_14179_((float)(progress / animationDuration), (float)0.0f, (float)1.0f) : (progress > 1.0f - animationDuration ? 1.0f - Mth.m_14179_((float)((progress - (1.0f - animationDuration)) / animationDuration), (float)0.0f, (float)1.0f) : 1.0f);
        int remainingSeconds = (int)Math.ceil((double)((long)this.duration - timeElapsed) / 1000.0);
        int x = (int)((float)screenWidth - (float)width * slideProgress);
        int y = screenHeight / 4 + 40;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280163_(TOAST_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        MutableComponent title = Component.m_237113_((String)"\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0442\u0443\u0440\u043d\u0438\u0440!");
        MutableComponent actions = Component.m_237113_((String)String.format("[%s] \u041f\u0440\u0438\u043d\u044f\u0442\u044c / [%s] \u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c", KeyBindingManager.DUEL_ACCEPT_KEY.m_90863_().getString().toUpperCase(), KeyBindingManager.DUEL_DECLINE_KEY.m_90863_().getString().toUpperCase()));
        MutableComponent countdown = Component.m_237113_((String)"\u041e\u0442\u0441\u0447\u0435\u0442: ").m_7220_((Component)Component.m_237113_((String)String.valueOf(remainingSeconds)).m_130940_(ChatFormatting.YELLOW)).m_130946_("\u0441");
        graphics.m_280614_(mc.f_91062_, (Component)title, x + 10, y + 12, 0xFF55FF, true);
        graphics.m_280614_(mc.f_91062_, (Component)actions, x + 10, y + 24, 0xFFFFFF, false);
        graphics.m_280614_(mc.f_91062_, (Component)countdown, x + 10, y + 36, -5592406, false);
        int timerWidth = (int)((1.0f - progress) * (float)(width - 20));
        graphics.m_280509_(x + 10, y + height - 8, x + 10 + timerWidth, y + height - 6, 0xFF55FF);
    }
}

