/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BANNED_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ARENAS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TOURNAMENT_ARENAS;
    public static final ForgeConfigSpec.IntValue DEFAULT_ELO;
    public static final ForgeConfigSpec.IntValue ARENA_CLEAR_DELAY;
    public static final ForgeConfigSpec.ConfigValue<String> TOURNAMENT_SPECTATOR_AREA;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TOURNAMENT_KITS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TOURNAMENT_REWARDS;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Advanced Duels General Settings").push("general");
        DEFAULT_ELO = builder.comment("Default Elo rating for new players.").defineInRange("defaultElo", 1000, 0, Integer.MAX_VALUE);
        ARENA_CLEAR_DELAY = builder.comment(new String[]{"Time in seconds to keep a non-keepInventory arena occupied after a duel ends.", "Allows the loser to retrieve their items."}).defineInRange("arenaClearDelay", 60, 0, 300);
        BANNED_ITEMS = builder.comment(new String[]{"List of items/tags to be presented as toggleable options in the duel GUI.", "Format for items: 'item_id;Display Text'", "Format for tags: 'tag:item_tag_id;Display Text'", "Example (item): 'minecraft:totem_of_undying;\u0422\u043e\u0442\u0435\u043c\u044b'", "Example (tag):  'tag:minecraft:wool;\u0412\u0441\u044f \u0448\u0435\u0440\u0441\u0442\u044c'"}).defineList("bannableItems", List.of("minecraft:totem_of_undying;\u0422\u043e\u0442\u0435\u043c\u044b \u0431\u0435\u0441\u0441\u043c\u0435\u0440\u0442\u0438\u044f", "minecraft:ender_pearl;\u042d\u043d\u0434\u0435\u0440-\u0436\u0435\u043c\u0447\u0443\u0433", "tag:minecraft:beds;\u041a\u0440\u043e\u0432\u0430\u0442\u0438", "tag:forge:chests;\u041b\u044e\u0431\u044b\u0435 \u0441\u0443\u043d\u0434\u0443\u043a\u0438"), obj -> obj instanceof String);
        ARENAS = builder.comment(new String[]{"List of duel arenas.", "Format: 'name;world_id;x1;y1;z1;yaw1;pitch1;x2;y2;z2;yaw2;pitch2'"}).defineList("arenas", List.of(), obj -> obj instanceof String);
        builder.pop();
        builder.comment("Tournament Settings").push("tournament");
        TOURNAMENT_ARENAS = builder.comment(new String[]{"List of dedicated arenas FOR TOURNAMENTS ONLY.", "Format: 'name;world_id;x1;y1;z1;yaw1;pitch1;x2;y2;z2;yaw2;pitch2'"}).defineList("tournamentArenas", List.of(), obj -> obj instanceof String);
        TOURNAMENT_SPECTATOR_AREA = builder.comment(new String[]{"Location where players are teleported when they join a tournament.", "Format: 'world_id;x;y;z;yaw;pitch'"}).define("spectatorArea", (Object)"minecraft:overworld;0.5;100.0;0.5;0.0;0.0");
        TOURNAMENT_KITS = builder.comment(new String[]{"List of kits for tournaments.", "Format: 'kitName;item_id,count;item_id,count;...'"}).defineList("kits", List.of("Warrior;minecraft:diamond_sword{Enchantments:[{id:sharpness,lvl:2}]},1;minecraft:shield,1;minecraft:diamond_helmet,1;minecraft:diamond_chestplate,1;minecraft:diamond_leggings,1;minecraft:diamond_boots,1;minecraft:cooked_beef,64", "Archer;minecraft:bow{Enchantments:[{id:power,lvl:3}]},1;minecraft:arrow,64;minecraft:iron_sword,1;minecraft:iron_helmet,1;minecraft:iron_chestplate,1;minecraft:iron_leggings,1;minecraft:iron_boots,1;minecraft:golden_apple,3"), obj -> obj instanceof String);
        TOURNAMENT_REWARDS = builder.comment(new String[]{"List of commands to be executed for the tournament winner.", "Use %player% as a placeholder for the winner's name."}).defineList("rewards", List.of("say Congratulations %player% for winning the tournament!"), obj -> obj instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

