/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.event;

import java.time.Instant;
import java.util.BitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ua.omega.omegaduels.client.gui.DuelToastGui;
import ua.omega.omegaduels.client.gui.MatchResultToastGui;
import ua.omega.omegaduels.client.gui.MatchToastGui;
import ua.omega.omegaduels.client.gui.PlayerTargetGui;
import ua.omega.omegaduels.client.gui.TournamentStartToastGui;
import ua.omega.omegaduels.client.gui.TournamentToastGui;
import ua.omega.omegaduels.client.keybinding.KeyBindingManager;
import ua.omega.omegaduels.data.PvPStatusTracker;
import ua.omega.omegaduels.network.PacketHandler;
import ua.omega.omegaduels.network.packets.C2S_KeybindDuelPacket;
import ua.omega.omegaduels.network.packets.C2S_OpenTournamentGUIPacket;
import ua.omega.omegaduels.network.packets.C2S_TournamentDeclinePacket;
import ua.omega.omegaduels.network.packets.C2S_TournamentJoinPacket;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="omegaduels", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    public static final PlayerTargetGui PLAYER_TARGET_GUI = new PlayerTargetGui();
    private static long lastPvpMessageTime = 0L;
    private static final long PVP_MESSAGE_DURATION_MS = 2500L;
    public static final DuelToastGui DUEL_TOAST = new DuelToastGui();
    public static final TournamentToastGui TOURNAMENT_TOAST = new TournamentToastGui();
    public static final MatchToastGui MATCH_TOAST = new MatchToastGui();
    public static final TournamentStartToastGui TOURNAMENT_START_TOAST = new TournamentStartToastGui();
    public static final MatchResultToastGui MATCH_RESULT_TOAST = new MatchResultToastGui();

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        EntityHitResult hitResult;
        HitResult hitResult2;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (KeyBindingManager.DUEL_REQUEST_KEY.m_90859_() && (hitResult2 = mc.f_91077_) instanceof EntityHitResult && (hitResult2 = (hitResult = (EntityHitResult)hitResult2).m_82443_()) instanceof Player) {
            Player target = (Player)hitResult2;
            PacketHandler.INSTANCE.sendToServer((Object)new C2S_KeybindDuelPacket(target.m_20148_()));
        }
        if (KeyBindingManager.TOURNAMENT_GUI_KEY.m_90859_()) {
            PacketHandler.INSTANCE.sendToServer((Object)new C2S_OpenTournamentGUIPacket());
        }
        if (DUEL_TOAST.isActive()) {
            if (KeyBindingManager.DUEL_ACCEPT_KEY.m_90859_()) {
                ClientEventHandler.sendCommand("duel accept " + DUEL_TOAST.getRequesterName());
                DUEL_TOAST.clear();
            } else if (KeyBindingManager.DUEL_DECLINE_KEY.m_90859_()) {
                ClientEventHandler.sendCommand("duel decline " + DUEL_TOAST.getRequesterName());
                DUEL_TOAST.clear();
            }
        }
        if (TOURNAMENT_TOAST.isActive()) {
            if (KeyBindingManager.DUEL_ACCEPT_KEY.m_90859_()) {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_TournamentJoinPacket());
                TOURNAMENT_TOAST.clear();
            } else if (KeyBindingManager.DUEL_DECLINE_KEY.m_90859_()) {
                PacketHandler.INSTANCE.sendToServer((Object)new C2S_TournamentDeclinePacket());
                TOURNAMENT_TOAST.clear();
            }
        }
    }

    @SubscribeEvent
    public static void onSystemChat(ClientChatReceivedEvent.System event) {
        String msg;
        if (event.isOverlay() && ((msg = event.getMessage().getString()).toLowerCase().contains("pvp") || msg.toLowerCase().contains("pve"))) {
            lastPvpMessageTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityHitResult hitResult;
            HitResult hitResult2;
            Minecraft mc = Minecraft.m_91087_();
            boolean isPvpActive = System.currentTimeMillis() - lastPvpMessageTime <= 2500L;
            PvPStatusTracker.setInPvP(isPvpActive);
            boolean shouldShowGui = false;
            if (mc.f_91074_ != null && mc.f_91073_ != null && mc.f_91080_ == null && (hitResult2 = mc.f_91077_) instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).m_82443_() instanceof Player && hitResult.m_82443_() != mc.f_91074_ && !PvPStatusTracker.isInPvP()) {
                shouldShowGui = true;
            }
            if (shouldShowGui) {
                PLAYER_TARGET_GUI.show();
            } else {
                PLAYER_TARGET_GUI.hide();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            DUEL_TOAST.render(event.getGuiGraphics());
            TOURNAMENT_TOAST.render(event.getGuiGraphics());
            MATCH_TOAST.render(event.getGuiGraphics());
            TOURNAMENT_START_TOAST.render(event.getGuiGraphics());
            MATCH_RESULT_TOAST.render(event.getGuiGraphics());
            PLAYER_TARGET_GUI.render(event.getGuiGraphics());
        }
    }

    private static void sendCommand(String command) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundChatCommandPacket(command, Instant.now(), 0L, ArgumentSignatures.f_240907_, new LastSeenMessages.Update(0, new BitSet())));
    }
}

