/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.client.gui.DuelPrepScreen;
import ua.omega.omegaduels.client.gui.TournamentScreen;
import ua.omega.omegaduels.event.ClientEventHandler;
import ua.omega.omegaduels.network.packets.S2C_ArenaListPacket;
import ua.omega.omegaduels.network.packets.S2C_CloseDuelGUIPacket;
import ua.omega.omegaduels.network.packets.S2C_DuelInfoPacket;
import ua.omega.omegaduels.network.packets.S2C_MatchResultToastPacket;
import ua.omega.omegaduels.network.packets.S2C_OpenTournamentScreenPacket;
import ua.omega.omegaduels.network.packets.S2C_ShowCountdownPacket;
import ua.omega.omegaduels.network.packets.S2C_ShowDuelToastPacket;
import ua.omega.omegaduels.network.packets.S2C_ShowMatchToastPacket;
import ua.omega.omegaduels.network.packets.S2C_SyncDuelStatePacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentInvitePacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentMatchEndPacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentRoundUpdatePacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentStartToastPacket;
import ua.omega.omegaduels.network.packets.S2C_TournamentUpdatePacket;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler {
    public static void handleCloseDuelGui(S2C_CloseDuelGUIPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91080_ instanceof DuelPrepScreen) {
                Minecraft.m_91087_().m_91152_(null);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleDuelInfo(S2C_DuelInfoPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Minecraft.m_91087_().m_91152_((Screen)new DuelPrepScreen(msg)));
        ctx.get().setPacketHandled(true);
    }

    public static void handleMatchResultToast(S2C_MatchResultToastPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.MATCH_RESULT_TOAST.show(msg.winnerName(), msg.loserName()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleOpenTournamentScreen(S2C_OpenTournamentScreenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Minecraft.m_91087_().m_91152_((Screen)new TournamentScreen(msg.getData())));
        ctx.get().setPacketHandled(true);
    }

    public static void handleShowCountdown(S2C_ShowCountdownPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            if (currentScreen instanceof DuelPrepScreen) {
                DuelPrepScreen screen = (DuelPrepScreen)currentScreen;
                screen.showCountdown(msg.getTitle(), msg.getDurationTicks());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleShowDuelToast(S2C_ShowDuelToastPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.DUEL_TOAST.show(msg.requesterName()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleShowMatchToast(S2C_ShowMatchToastPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.MATCH_TOAST.show(msg.player1Name(), msg.player2Name(), msg.countdownSeconds()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleSyncDuelState(S2C_SyncDuelStatePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            if (currentScreen instanceof DuelPrepScreen) {
                DuelPrepScreen screen = (DuelPrepScreen)currentScreen;
                screen.updateState(msg.settings(), msg.localPlayerReady(), msg.opponentReady());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleTournamentInvite(S2C_TournamentInvitePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.TOURNAMENT_TOAST.show(msg.timeoutSeconds()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleTournamentMatchEnd(S2C_TournamentMatchEndPacket msg) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof TournamentScreen) {
            TournamentScreen screen2 = (TournamentScreen)screen;
            screen2.updateMatchResult(msg.roundIndex(), msg.matchIndex(), msg.winnerId());
        }
    }

    public static void handleTournamentRoundUpdate(S2C_TournamentRoundUpdatePacket msg) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof TournamentScreen) {
            TournamentScreen screen2 = (TournamentScreen)screen;
            screen2.updateRound(msg.getRoundIndex(), msg.getMatchups());
        }
    }

    public static void handleTournamentStartToast(S2C_TournamentStartToastPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.TOURNAMENT_START_TOAST.show());
        ctx.get().setPacketHandled(true);
    }

    public static void handleTournamentUpdate(S2C_TournamentUpdatePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            if (currentScreen instanceof TournamentScreen) {
                TournamentScreen screen = (TournamentScreen)currentScreen;
                screen.updateState(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleArenaList(S2C_ArenaListPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            if (currentScreen instanceof DuelPrepScreen) {
                DuelPrepScreen screen = (DuelPrepScreen)currentScreen;
                screen.updateArenaData(msg.arenas(), msg.canSelectArena());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

