/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.OmegaDuels;

public record S2C_ArenaListPacket(List<ArenaInfo> arenas, boolean canSelectArena) {
    public static void encode(S2C_ArenaListPacket msg, FriendlyByteBuf buf) {
        buf.m_236828_(msg.arenas, (b, arena) -> {
            b.m_130070_(arena.name);
            b.writeBoolean(arena.isOccupied);
        });
        buf.writeBoolean(msg.canSelectArena);
    }

    public static S2C_ArenaListPacket decode(FriendlyByteBuf buf) {
        List arenas = (List)buf.m_236838_(ArrayList::new, b -> new ArenaInfo(b.m_130277_(), b.readBoolean()));
        boolean canSelectArena = buf.readBoolean();
        return new S2C_ArenaListPacket(arenas, canSelectArena);
    }

    public record ArenaInfo(String name, boolean isOccupied) {
    }

    public static class Handler {
        public static void handle(S2C_ArenaListPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> OmegaDuels.proxy.handleArenaList(msg, ctx));
            ctx.get().setPacketHandled(true);
        }
    }
}

