/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.OmegaDuels;

public class S2C_DuelInfoPacket {
    private final String selfName;
    private final String opponentName;
    private final UUID opponentUUID;
    private final NonNullList<ItemStack> opponentMainInventory;
    private final NonNullList<ItemStack> opponentArmorInventory;
    private final NonNullList<ItemStack> opponentCuriosInventory;
    private final int selfWins;
    private final int selfLosses;
    private final int opponentWins;
    private final int opponentLosses;

    public S2C_DuelInfoPacket(String selfName, String opponentName, UUID opponentUUID, NonNullList<ItemStack> mainInv, NonNullList<ItemStack> armorInv, NonNullList<ItemStack> curInv, int selfWins, int selfLosses, int opponentWins, int opponentLosses) {
        this.selfName = selfName;
        this.opponentName = opponentName;
        this.opponentUUID = opponentUUID;
        this.opponentMainInventory = mainInv;
        this.opponentArmorInventory = armorInv;
        this.opponentCuriosInventory = curInv;
        this.selfWins = selfWins;
        this.selfLosses = selfLosses;
        this.opponentWins = opponentWins;
        this.opponentLosses = opponentLosses;
    }

    public static void encode(S2C_DuelInfoPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.selfName);
        buf.m_130070_(msg.opponentName);
        buf.m_130077_(msg.opponentUUID);
        buf.m_236828_(msg.opponentMainInventory, FriendlyByteBuf::m_130055_);
        buf.m_236828_(msg.opponentArmorInventory, FriendlyByteBuf::m_130055_);
        buf.m_236828_(msg.opponentCuriosInventory, FriendlyByteBuf::m_130055_);
        buf.writeInt(msg.selfWins);
        buf.writeInt(msg.selfLosses);
        buf.writeInt(msg.opponentWins);
        buf.writeInt(msg.opponentLosses);
    }

    public static S2C_DuelInfoPacket decode(FriendlyByteBuf buf) {
        String selfName = buf.m_130277_();
        String opponentName = buf.m_130277_();
        UUID opponentUUID = buf.m_130259_();
        NonNullList mainInv = NonNullList.m_122779_();
        buf.m_236838_(v -> mainInv, FriendlyByteBuf::m_130267_);
        NonNullList armorInv = NonNullList.m_122779_();
        buf.m_236838_(v -> armorInv, FriendlyByteBuf::m_130267_);
        NonNullList curInv = NonNullList.m_122779_();
        buf.m_236838_(v -> curInv, FriendlyByteBuf::m_130267_);
        int selfWins = buf.readInt();
        int selfLosses = buf.readInt();
        int opponentWins = buf.readInt();
        int opponentLosses = buf.readInt();
        return new S2C_DuelInfoPacket(selfName, opponentName, opponentUUID, (NonNullList<ItemStack>)mainInv, (NonNullList<ItemStack>)armorInv, (NonNullList<ItemStack>)curInv, selfWins, selfLosses, opponentWins, opponentLosses);
    }

    public int getSelfWins() {
        return this.selfWins;
    }

    public int getSelfLosses() {
        return this.selfLosses;
    }

    public int getOpponentWins() {
        return this.opponentWins;
    }

    public int getOpponentLosses() {
        return this.opponentLosses;
    }

    public String getSelfName() {
        return this.selfName;
    }

    public String getOpponentName() {
        return this.opponentName;
    }

    public UUID getOpponentUUID() {
        return this.opponentUUID;
    }

    public NonNullList<ItemStack> getOpponentMainInventory() {
        return this.opponentMainInventory;
    }

    public NonNullList<ItemStack> getOpponentArmorInventory() {
        return this.opponentArmorInventory;
    }

    public NonNullList<ItemStack> getOpponentCuriosInventory() {
        return this.opponentCuriosInventory;
    }

    public static class Handler {
        public static void handle(S2C_DuelInfoPacket msg, Supplier<NetworkEvent.Context> ctx) {
            OmegaDuels.proxy.handleDuelInfo(msg, ctx);
        }
    }
}

