/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network.packets;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.OmegaDuels;
import ua.omega.omegaduels.duel.DuelSettings;

public record S2C_SyncDuelStatePacket(DuelSettings settings, boolean localPlayerReady, boolean opponentReady) {
    public static void encode(S2C_SyncDuelStatePacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.settings.isKeepInventory());
        buf.m_236828_(msg.settings.getBannedItemsAndTags(), FriendlyByteBuf::m_130070_);
        buf.writeBoolean(msg.localPlayerReady);
        buf.writeBoolean(msg.opponentReady);
    }

    public static S2C_SyncDuelStatePacket decode(FriendlyByteBuf buf) {
        DuelSettings settings = new DuelSettings();
        settings.setKeepInventory(buf.readBoolean());
        settings.setBannedItemsAndTags((Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130277_));
        boolean localReady = buf.readBoolean();
        boolean opponentReady = buf.readBoolean();
        return new S2C_SyncDuelStatePacket(settings, localReady, opponentReady);
    }

    public static class Handler {
        public static void handle(S2C_SyncDuelStatePacket msg, Supplier<NetworkEvent.Context> ctx) {
            OmegaDuels.proxy.handleSyncDuelState(msg, ctx);
        }
    }
}

