/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.OmegaDuels;

public final class S2C_TournamentRoundUpdatePacket {
    private final int roundIndex;
    private final List<Matchup> matchups;

    private S2C_TournamentRoundUpdatePacket(int roundIndex, List<Matchup> matchups) {
        this.roundIndex = roundIndex;
        this.matchups = matchups;
    }

    private static S2C_TournamentRoundUpdatePacket createFromMatchups(int roundIndex, List<Matchup> matchups) {
        return new S2C_TournamentRoundUpdatePacket(roundIndex, matchups);
    }

    public static void encode(S2C_TournamentRoundUpdatePacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.roundIndex);
        buf.m_236828_(msg.matchups, (b, m) -> m.encode((FriendlyByteBuf)b));
    }

    public static S2C_TournamentRoundUpdatePacket decode(FriendlyByteBuf buf) {
        int roundIndex = buf.readInt();
        List matchups = (List)buf.m_236838_(ArrayList::new, Matchup::decode);
        return S2C_TournamentRoundUpdatePacket.createFromMatchups(roundIndex, matchups);
    }

    public int getRoundIndex() {
        return this.roundIndex;
    }

    public List<Matchup> getMatchups() {
        return this.matchups;
    }

    public record Matchup(@Nullable UUID p1, @Nullable UUID p2) {
        public void encode(FriendlyByteBuf buf) {
            buf.m_236821_((Object)this.p1, FriendlyByteBuf::m_130077_);
            buf.m_236821_((Object)this.p2, FriendlyByteBuf::m_130077_);
        }

        public static Matchup decode(FriendlyByteBuf buf) {
            return new Matchup((UUID)buf.m_236868_(FriendlyByteBuf::m_130259_), (UUID)buf.m_236868_(FriendlyByteBuf::m_130259_));
        }
    }

    public static class Handler {
        public static void handle(S2C_TournamentRoundUpdatePacket msg, Supplier<NetworkEvent.Context> ctx) {
            OmegaDuels.proxy.handleTournamentRoundUpdate(msg, ctx);
        }
    }
}

