/*
 * Decompiled with CFR 0.152.
 */
package ua.omega.omegaduels.network.packets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ua.omega.omegaduels.OmegaDuels;
import ua.omega.omegaduels.tournament.TournamentState;

public class S2C_TournamentUpdatePacket {
    private final TournamentState state;
    private final List<ParticipantInfo> participants;
    private final BracketInfo bracketInfo;
    private final String kitName;
    private final List<ItemStack> kitItems;

    private S2C_TournamentUpdatePacket(TournamentState state, List<ParticipantInfo> participants, BracketInfo bracketInfo, String kitName, List<ItemStack> kitItems) {
        this.state = state;
        this.participants = participants;
        this.bracketInfo = bracketInfo;
        this.kitName = kitName;
        this.kitItems = kitItems;
    }

    public static void encode(S2C_TournamentUpdatePacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.state);
        buf.m_236828_(msg.participants, (b, p) -> p.encode((FriendlyByteBuf)b));
        msg.bracketInfo.encode(buf);
        buf.m_130070_(msg.kitName);
        buf.m_236828_(msg.kitItems, FriendlyByteBuf::m_130055_);
    }

    public static S2C_TournamentUpdatePacket decode(FriendlyByteBuf buf) {
        TournamentState state = (TournamentState)buf.m_130066_(TournamentState.class);
        List participants = (List)buf.m_236838_(ArrayList::new, ParticipantInfo::decode);
        BracketInfo bracketInfo = BracketInfo.decode(buf);
        String kitName = buf.m_130277_();
        List kitItems = (List)buf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130267_);
        return new S2C_TournamentUpdatePacket(state, participants, bracketInfo, kitName, kitItems);
    }

    public TournamentState getState() {
        return this.state;
    }

    public List<ParticipantInfo> getParticipants() {
        return this.participants;
    }

    public BracketInfo getBracketInfo() {
        return this.bracketInfo;
    }

    public String getKitName() {
        return this.kitName;
    }

    public List<ItemStack> getKitItems() {
        return this.kitItems;
    }

    public static final class BracketInfo {
        private final List<List<MatchInfo>> rounds;

        public BracketInfo(List<List<MatchInfo>> rounds) {
            this.rounds = rounds;
        }

        public List<List<MatchInfo>> getRounds() {
            return this.rounds;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_236828_(this.rounds, (b, round) -> b.m_236828_((Collection)round, (b2, match) -> match.encode((FriendlyByteBuf)b2)));
        }

        public static BracketInfo decode(FriendlyByteBuf buf) {
            List decodedRounds = (List)buf.m_236838_(ArrayList::new, b -> (List)b.m_236838_(ArrayList::new, MatchInfo::decode));
            return new BracketInfo(decodedRounds);
        }
    }

    public static final class ParticipantInfo {
        private final UUID uuid;
        private final String name;
        private final int elo;

        public ParticipantInfo(UUID uuid, String name, int elo) {
            this.uuid = uuid;
            this.name = name;
            this.elo = elo;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public int getElo() {
            return this.elo;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.uuid);
            buf.m_130070_(this.name);
            buf.writeInt(this.elo);
        }

        public static ParticipantInfo decode(FriendlyByteBuf buf) {
            return new ParticipantInfo(buf.m_130259_(), buf.m_130277_(), buf.readInt());
        }
    }

    public static final class MatchInfo {
        private final UUID p1;
        private final UUID p2;
        private final UUID winner;

        public MatchInfo(@Nullable UUID p1, @Nullable UUID p2, @Nullable UUID winner) {
            this.p1 = p1;
            this.p2 = p2;
            this.winner = winner;
        }

        @Nullable
        public UUID getP1() {
            return this.p1;
        }

        @Nullable
        public UUID getP2() {
            return this.p2;
        }

        @Nullable
        public UUID getWinner() {
            return this.winner;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_236821_((Object)this.p1, FriendlyByteBuf::m_130077_);
            buf.m_236821_((Object)this.p2, FriendlyByteBuf::m_130077_);
            buf.m_236821_((Object)this.winner, FriendlyByteBuf::m_130077_);
        }

        public static MatchInfo decode(FriendlyByteBuf buf) {
            return new MatchInfo((UUID)buf.m_236868_(FriendlyByteBuf::m_130259_), (UUID)buf.m_236868_(FriendlyByteBuf::m_130259_), (UUID)buf.m_236868_(FriendlyByteBuf::m_130259_));
        }
    }

    public static class Handler {
        public static void handle(S2C_TournamentUpdatePacket msg, Supplier<NetworkEvent.Context> ctx) {
            OmegaDuels.proxy.handleTournamentUpdate(msg, ctx);
        }
    }
}

