/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.experimental.entity.block_caching.fluid_pushing;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCache;
import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCacheProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements BlockCacheProvider {
    @Shadow
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract Level m_9236_();

    @Inject(method={"updateMovementInFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipFluidSearchUsingCache(TagKey<Fluid> fluid, double speed, CallbackInfoReturnable<Boolean> cir) {
        BlockCache bc = this.getUpdatedBlockCache((Entity)this);
        double fluidHeight = bc.getStationaryFluidHeightOrDefault(fluid, -1.0);
        if (fluidHeight != -1.0) {
            this.f_19799_.put(fluid, fluidHeight);
            boolean touchingFluid = fluidHeight != 0.0;
            cir.setReturnValue((Object)touchingFluid);
        }
    }

    @Inject(method={"updateMovementInFluid"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/Vec3d;length()D", ordinal=0, shift=At.Shift.BEFORE)})
    private void cacheFluidSearchResult(TagKey<Fluid> fluid, double speed, CallbackInfoReturnable<Boolean> cir, AABB box, int i1, int i2, int i3, int i4, int i5, int i6, double fluidHeight, boolean isPushedbyFluids, boolean touchingFluid, Vec3 fluidPush, int i7) {
        BlockCache bc = this.getBlockCache();
        if (bc.isTracking() && fluidPush.m_82556_() == 0.0) {
            if (touchingFluid == (fluidHeight == 0.0)) {
                throw new IllegalArgumentException("Expected fluid touching IFF fluid height is not 0! Fluid height: " + fluidHeight + " Touching fluid: " + touchingFluid + " Fluid Tag: " + fluid);
            }
            bc.setCachedFluidHeight(fluid, fluidHeight);
        }
    }
}

