/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;

public class StorageInventorySlot
extends SlotSuppliedHandler {
    private final boolean isClientSide;
    private final IStorageWrapper storageWrapper;
    private final int slotIndex;
    private final Player player;

    public StorageInventorySlot(boolean isClientSide, IStorageWrapper storageWrapper, int slotIndex, Player player) {
        super(storageWrapper::getInventoryHandler, slotIndex, 0, 0);
        this.isClientSide = isClientSide;
        this.storageWrapper = storageWrapper;
        this.slotIndex = slotIndex;
        this.player = player;
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        return this.storageWrapper.getInventoryHandler().isItemValid(this.slotIndex, stack, this.player);
    }

    public void m_6654_() {
        super.m_6654_();
        this.storageWrapper.getInventoryHandler().onContentsChanged(this.slotIndex);
        this.processSlotChangeResponse(this.slotIndex, (IItemHandler)this.storageWrapper.getInventoryHandler(), this.storageWrapper);
    }

    private void processSlotChangeResponse(int slot, IItemHandler handler, IStorageWrapper storageWrapper) {
        if (!this.isClientSide) {
            storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(ISlotChangeResponseUpgrade.class).forEach(u -> u.onSlotChange(handler, slot));
        }
    }

    public int m_5866_(ItemStack stack) {
        return this.storageWrapper.getInventoryHandler().getStackLimit(this.slotIndex, stack);
    }

    public ItemStack m_150656_(ItemStack stack, int maxCount) {
        if (!stack.m_41619_() && this.m_5857_(stack)) {
            ItemStack itemstack = this.m_7993_();
            int i = Math.min(Math.min(maxCount, stack.m_41613_()), this.m_5866_(stack) - itemstack.m_41613_());
            if (itemstack.m_41619_()) {
                this.m_5852_(stack.m_41620_(i));
            } else if (ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack)) {
                stack.m_41774_(i);
                ItemStack copy = itemstack.m_41777_();
                copy.m_41769_(i);
                this.m_5852_(copy);
            }
            return stack;
        }
        return stack;
    }

    public boolean isInfinite() {
        return this.storageWrapper.getInventoryHandler().isInfinite(this.slotIndex);
    }
}

