/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CraftingUpgradeContainer
extends UpgradeContainerBase<CraftingUpgradeWrapper, CraftingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private static final String DATA_SELECT_RESULT = "selectResult";
    private final ResultContainer craftResult = new ResultContainer();
    private final CraftingItemHandler craftMatrix;
    private final ResultSlot craftingResultSlot;
    @Nullable
    private CraftingRecipe lastRecipe = null;
    private List<CraftingRecipe> matchedCraftingRecipes = new ArrayList<CraftingRecipe>();
    private List<ItemStack> matchedCraftingResults = new ArrayList<ItemStack>();
    private int selectedCraftingResultIndex = 0;

    public CraftingUpgradeContainer(final Player player, int upgradeContainerId, CraftingUpgradeWrapper upgradeWrapper, UpgradeContainerType<CraftingUpgradeWrapper, CraftingUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        int slot;
        for (slot = 0; slot < upgradeWrapper.getInventory().getSlots(); ++slot) {
            this.slots.add(new SlotSuppliedHandler(upgradeWrapper::getInventory, slot, -100, -100){

                public void m_6654_() {
                    super.m_6654_();
                    CraftingUpgradeContainer.this.updateCraftingResult(player.m_9236_(), player, (CraftingContainer)CraftingUpgradeContainer.this.craftMatrix, CraftingUpgradeContainer.this.craftResult, CraftingUpgradeContainer.this.craftingResultSlot);
                    CraftingUpgradeContainer.this.craftMatrix.m_6596_();
                }
            });
        }
        this.craftMatrix = new CraftingItemHandler(upgradeWrapper::getInventory, this::onCraftMatrixChanged);
        this.craftingResultSlot = new ResultSlot(player, (CraftingContainer)this.craftMatrix, (Container)this.craftResult, slot, -100, -100){

            public void m_142406_(Player thePlayer, ItemStack stack) {
                ItemStack remainingStack = this.m_7993_();
                this.m_5845_(stack);
                ForgeHooks.setCraftingPlayer((Player)thePlayer);
                NonNullList items = CraftingUpgradeContainer.this.lastRecipe != null && CraftingUpgradeContainer.this.lastRecipe.m_5818_((Container)CraftingUpgradeContainer.this.craftMatrix, player.m_9236_()) ? CraftingUpgradeContainer.this.lastRecipe.m_7457_((Container)CraftingUpgradeContainer.this.craftMatrix) : CraftingUpgradeContainer.this.craftMatrix.m_280657_();
                ForgeHooks.setCraftingPlayer(null);
                for (int i = 0; i < items.size(); ++i) {
                    if (i >= 9) {
                        this.logErrorAndDropRemainingItems(i, (List<ItemStack>)items);
                        break;
                    }
                    ItemStack itemstack = CraftingUpgradeContainer.this.craftMatrix.m_8020_(i);
                    ItemStack itemstack1 = (ItemStack)items.get(i);
                    if (!itemstack.m_41619_()) {
                        CraftingUpgradeContainer.this.craftMatrix.m_7407_(i, 1);
                        itemstack = CraftingUpgradeContainer.this.craftMatrix.m_8020_(i);
                    }
                    if (itemstack1.m_41619_()) continue;
                    if (itemstack.m_41619_()) {
                        CraftingUpgradeContainer.this.craftMatrix.m_6836_(i, itemstack1);
                        continue;
                    }
                    if (ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                        itemstack1.m_41769_(itemstack.m_41613_());
                        CraftingUpgradeContainer.this.craftMatrix.m_6836_(i, itemstack1);
                        continue;
                    }
                    if (player.m_150109_().m_36054_(itemstack1)) continue;
                    player.m_36176_(itemstack1, false);
                }
                if (!remainingStack.m_41619_()) {
                    player.m_36176_(remainingStack, false);
                }
            }

            private void logErrorAndDropRemainingItems(int i, List<ItemStack> items) {
                for (int j = i; j < items.size(); ++j) {
                    ItemStack remaining = items.get(j);
                    if (remaining.m_41619_()) continue;
                    player.m_36176_(remaining, false);
                }
                SophisticatedCore.LOGGER.error("Recipe " + String.valueOf(CraftingUpgradeContainer.this.lastRecipe != null ? CraftingUpgradeContainer.this.lastRecipe.m_6423_() : "[unknown]") + " returned more than 9 remaining items, dropping the rest!");
            }

            public void m_6654_() {
                super.m_6654_();
                if (player.m_9236_().m_5776_()) {
                    CraftingUpgradeContainer.this.matchedCraftingRecipes.clear();
                    CraftingUpgradeContainer.this.matchedCraftingResults.clear();
                    if (!this.m_7993_().m_41619_()) {
                        CraftingUpgradeContainer.this.matchedCraftingRecipes = RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, CraftingUpgradeContainer.this.craftMatrix, player.m_9236_());
                        int resultIndex = 0;
                        for (CraftingRecipe craftingRecipe : CraftingUpgradeContainer.this.matchedCraftingRecipes) {
                            ItemStack result = craftingRecipe.m_5874_((Container)CraftingUpgradeContainer.this.craftMatrix, player.m_9236_().m_9598_());
                            CraftingUpgradeContainer.this.matchedCraftingResults.add(result);
                            if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.m_7993_(), (ItemStack)result)) {
                                CraftingUpgradeContainer.this.selectedCraftingResultIndex = resultIndex;
                            }
                            ++resultIndex;
                        }
                    }
                }
            }
        };
        this.slots.add(this.craftingResultSlot);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.onCraftMatrixChanged((Container)this.craftMatrix);
    }

    private void onCraftMatrixChanged(Container iInventory) {
        this.updateCraftingResult(this.player.m_9236_(), this.player, (CraftingContainer)this.craftMatrix, this.craftResult, this.craftingResultSlot);
    }

    private void updateCraftingResult(Level level, Player player, CraftingContainer inventory, ResultContainer inventoryResult, ResultSlot craftingResultSlot) {
        if (!level.f_46443_) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            if (this.lastRecipe != null && this.lastRecipe.m_5818_((Container)inventory, level)) {
                itemstack = this.lastRecipe.m_5874_((Container)inventory, level.m_9598_());
            } else {
                List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, inventory, level);
                if (!recipes.isEmpty()) {
                    this.matchedCraftingRecipes = recipes;
                    this.matchedCraftingResults.clear();
                    this.selectedCraftingResultIndex = 0;
                    CraftingRecipe craftingRecipe = this.matchedCraftingRecipes.get(0);
                    if (inventoryResult.m_40135_(level, serverplayerentity, (Recipe)craftingRecipe)) {
                        this.lastRecipe = craftingRecipe;
                        itemstack = this.lastRecipe.m_5874_((Container)inventory, level.m_9598_());
                        this.matchedCraftingResults.add(itemstack.m_41777_());
                    } else {
                        this.lastRecipe = null;
                    }
                    for (int i = 1; i < this.matchedCraftingRecipes.size(); ++i) {
                        this.matchedCraftingResults.add(this.matchedCraftingRecipes.get(i).m_5874_((Container)inventory, level.m_9598_()));
                    }
                }
            }
            craftingResultSlot.m_5852_(itemstack);
        }
    }

    public List<ItemStack> getMatchedCraftingResults() {
        return this.matchedCraftingResults;
    }

    public void selectNextCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectPreviousCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + this.matchedCraftingResults.size() - 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectCraftingResult(int resultIndex) {
        if (resultIndex < 0 || resultIndex >= this.matchedCraftingResults.size()) {
            return;
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.selectedCraftingResultIndex = resultIndex;
            this.lastRecipe = this.matchedCraftingRecipes.get(resultIndex);
            ItemStack result = this.matchedCraftingResults.get(resultIndex).m_41777_();
            this.craftingResultSlot.m_5852_(result);
            this.craftResult.m_40135_(this.player.m_9236_(), serverPlayer, (Recipe)this.lastRecipe);
        } else {
            this.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), DATA_SELECT_RESULT, resultIndex));
        }
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else if (data.m_128441_(DATA_SELECT_RESULT)) {
            this.selectCraftingResult(data.m_128451_(DATA_SELECT_RESULT));
        }
    }

    @Override
    public ItemStack getSlotStackToTransfer(Slot slot) {
        if (slot == this.craftingResultSlot) {
            ItemStack slotStack = slot.m_7993_();
            slotStack.m_41720_().m_7836_(slotStack, this.player.m_9236_(), this.player);
            return slotStack;
        }
        return super.getSlotStackToTransfer(slot);
    }

    @Override
    public List<Slot> getRecipeSlots() {
        return this.slots.subList(0, 9);
    }

    @Override
    public Container getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public void setRecipeUsed(ResourceLocation recipeId) {
        if (this.lastRecipe != null && this.lastRecipe.m_6423_().equals((Object)recipeId)) {
            return;
        }
        this.player.m_9236_().m_7465_().m_44043_(recipeId).filter(r -> r.m_6671_() == RecipeType.f_44107_).map(r -> (CraftingRecipe)r).ifPresent(recipe -> {
            this.lastRecipe = recipe;
            for (int i = 0; i < this.matchedCraftingRecipes.size(); ++i) {
                if (!this.matchedCraftingRecipes.get(i).m_6423_().equals((Object)recipeId)) continue;
                this.selectCraftingResult(i);
                return;
            }
        });
    }

    @Override
    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44107_;
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((CraftingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((CraftingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    @Override
    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return slot != this.craftingResultSlot;
    }
}

