/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import pro.komaru.tridot.TridotLibClient;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.api.level.loot.conditions.LootConditionsRegistry;
import pro.komaru.tridot.api.networking.PacketHandler;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.render.gui.overlay.OverlayHandler;
import pro.komaru.tridot.common.Events;
import pro.komaru.tridot.common.commands.ModArgumentTypes;
import pro.komaru.tridot.common.config.ClientConfig;
import pro.komaru.tridot.common.config.CommonConfig;
import pro.komaru.tridot.common.networking.proxy.ClientProxy;
import pro.komaru.tridot.common.networking.proxy.ISidedProxy;
import pro.komaru.tridot.common.networking.proxy.ServerProxy;
import pro.komaru.tridot.common.registry.EnchantmentsRegistry;
import pro.komaru.tridot.common.registry.TridotLootModifier;
import pro.komaru.tridot.common.registry.block.TridotBlockEntities;
import pro.komaru.tridot.common.registry.block.TridotBlocks;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.common.registry.item.types.TestItem;

@Mod(value="tridot")
public class Tridot {
    public static final String ID = "tridot";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static UUID BASE_PROJECTILE_DAMAGE_UUID = UUID.fromString("5334b818-69d4-417e-b4b8-1869d4917e29");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tridot");
    public static final RegistryObject<Item> TEST = ITEMS.register("test", () -> new TestItem(new Item.Properties().m_41497_(Rarity.EPIC)));
    public static final ISidedProxy PROXY = (ISidedProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public Tridot() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EnchantmentsRegistry.register(eventBus);
        AttributeRegistry.register(eventBus);
        TridotBlocks.register(eventBus);
        TridotBlockEntities.register(eventBus);
        TridotParticles.register(eventBus);
        TridotLootModifier.register(eventBus);
        LootConditionsRegistry.init(eventBus);
        ModArgumentTypes.register(eventBus);
        ITEMS.register(eventBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            forgeBus.addListener(OverlayHandler::tickInstances);
            forgeBus.addListener(OverlayHandler::renderInstances);
            forgeBus.addListener(OverlayRenderItem::onDrawScreenPost);
            forgeBus.addListener(ClientTick::clientTickEnd);
            TridotLibClient.clientInit();
            return new Object();
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        eventBus.addListener(this::setup);
        eventBus.addListener(TridotLibClient::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static ResourceLocation ofTridot(String path) {
        return new ResourceLocation(ID, path);
    }

    private void setup(FMLCommonSetupEvent event) {
        TridotBlocks.setFireBlock();
        PacketHandler.init();
        for (ItemSkin skin : SkinRegistryManager.getSkins()) {
            skin.setupSkinEntries();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void attachAttribute(EntityAttributeModificationEvent event) {
            for (EntityType type : event.getTypes()) {
                event.add(type, (Attribute)AttributeRegistry.PERCENT_ARMOR.get());
            }
            event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get());
        }
    }
}

