/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.client.BossBarsOverlay;
import pro.komaru.tridot.client.ClientEvents;
import pro.komaru.tridot.client.compatibility.ShadersIntegration;
import pro.komaru.tridot.client.gfx.TridotScreenParticles;
import pro.komaru.tridot.client.render.gui.particle.ParticleEmitterHandler;
import pro.komaru.tridot.client.sound.LoopedSoundInstance;
import pro.komaru.tridot.client.sound.TridotSoundInstance;
import pro.komaru.tridot.client.tooltip.TooltipModifierHandler;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.EffectsListComponent;
import pro.komaru.tridot.common.registry.item.components.EmptyComponent;
import pro.komaru.tridot.common.registry.item.components.LineSeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.common.registry.item.components.client.AbilityClientComponent;
import pro.komaru.tridot.common.registry.item.components.client.EffectListClientComponent;
import pro.komaru.tridot.common.registry.item.components.client.EmptyClientComponent;
import pro.komaru.tridot.common.registry.item.components.client.LineSeparatorClientComponent;
import pro.komaru.tridot.common.registry.item.components.client.SeparatorClientComponent;
import pro.komaru.tridot.common.registry.item.components.client.TextClientComponent;

public class TridotLibClient {
    public static LoopedSoundInstance BOSS_MUSIC;
    public static TridotSoundInstance COOLDOWN_SOUND;
    public static TridotSoundInstance DUNGEON_MUSIC_INSTANCE;

    public static void clientSetup(FMLClientSetupEvent event) {
        ShadersIntegration.init();
    }

    public static void clientInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.register((Object)new ClientEvents());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerComponents(RegisterClientTooltipComponentFactoriesEvent e) {
            e.register(SeparatorComponent.class, c -> SeparatorClientComponent.create(c.component()));
            e.register(LineSeparatorComponent.class, c -> LineSeparatorClientComponent.create());
            e.register(AbilityComponent.class, c -> AbilityClientComponent.create(c.component(), c.icon(), c.paddingTop(), c.iconSize()));
            e.register(TextComponent.class, c -> TextClientComponent.create(c.component()));
            e.register(EffectsListComponent.class, c -> EffectListClientComponent.create(c.list(), c.component()));
            e.register(EmptyComponent.class, c -> EmptyClientComponent.create(c.height()));
        }

        @SubscribeEvent
        public static void registerOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("boss_bars", (IGuiOverlay)BossBarsOverlay.INSTANCE);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ParticleEmitterHandler.registerEmitters(event);
        }

        @SubscribeEvent
        public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
            TridotScreenParticles.registerParticleFactory(event);
        }

        @SubscribeEvent
        public static void registerAttributeModifiers(FMLClientSetupEvent event) {
            TooltipModifierHandler.add(Tridot.BASE_PROJECTILE_DAMAGE_UUID);
        }
    }
}

