/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.level.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import pro.komaru.tridot.api.level.event.GameplayEvent;
import pro.komaru.tridot.api.level.event.GameplayEvents;
import pro.komaru.tridot.util.struct.data.Seq;

public class GameplayEventManager
extends SavedData {
    public static final Seq<ResourceLocation> activeEvents = Seq.with();
    private transient int tickCounter = 0;

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (ResourceLocation id : activeEvents) {
            list.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        nbt.m_128365_("ActiveEvents", (Tag)list);
        return nbt;
    }

    public static GameplayEventManager load(CompoundTag nbt) {
        GameplayEventManager manager = new GameplayEventManager();
        ListTag list = nbt.m_128437_("ActiveEvents", 8);
        for (int i = 0; i < list.size(); ++i) {
            activeEvents.add(new ResourceLocation(list.m_128778_(i)));
        }
        return manager;
    }

    public static GameplayEventManager get(ServerLevel server) {
        DimensionDataStorage storage = server.m_8895_();
        return (GameplayEventManager)storage.m_164861_(GameplayEventManager::load, GameplayEventManager::new, "gameplay_events");
    }

    public boolean isEventActive(ResourceLocation eventId) {
        return activeEvents.contains(eventId);
    }

    public void tickAllEvents(ServerLevel server) {
        if (this.tickCounter++ % 20 != 0) {
            return;
        }
        for (ResourceLocation eventId : activeEvents) {
            GameplayEvent event = GameplayEvents.get(eventId);
            if (event == null) continue;
            boolean conditionsMet = event.test(server);
            boolean wasActive = activeEvents.contains(eventId);
            if (conditionsMet && !wasActive) {
                this.startEvent(eventId, server);
                continue;
            }
            if (conditionsMet || !wasActive) continue;
            this.stopEvent(eventId, server);
        }
    }

    public void tickActiveEvents(ServerLevel server) {
        activeEvents.forEach(id -> {
            GameplayEvent event = GameplayEvents.get(id);
            if (event != null) {
                event.onTick(server);
            }
        });
    }

    public boolean startEvent(ResourceLocation eventId, ServerLevel server) {
        if (activeEvents.contains(eventId)) {
            return false;
        }
        GameplayEvent event = GameplayEvents.get(eventId);
        if (event != null) {
            activeEvents.add(eventId);
            event.onStart(server);
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean stopEvent(ResourceLocation eventId, ServerLevel server) {
        if (activeEvents.remove(eventId)) {
            GameplayEvent event = GameplayEvents.get(eventId);
            if (event != null) {
                event.onStop(server);
            }
            this.m_77762_();
            return true;
        }
        return false;
    }
}

