/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.render.text;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.render.GuiDraw;
import pro.komaru.tridot.api.render.text.TextRenderProps;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.phys.AbsRect;

public class TextBuilder {
    static float[] tmp = new float[2];
    public MutableComponent text;
    public TextRenderProps renderProps;

    public TextBuilder(MutableComponent text) {
        this.text = text;
        this.renderProps = new TextRenderProps();
    }

    public TextBuilder renderStyle(UnaryOperator<TextRenderProps> renderStyle) {
        this.renderProps = (TextRenderProps)renderStyle.apply(this.renderProps);
        return this;
    }

    public TextBuilder add(String text) {
        this.text.m_130946_(text);
        return this;
    }

    public TextBuilder add(Component component) {
        this.text.m_7220_(component);
        return this;
    }

    public TextBuilder add(TextBuilder builder) {
        this.text.m_7220_((Component)builder.get());
        return this;
    }

    public TextBuilder color(TextColor col) {
        return this.style(style -> style.color(col));
    }

    public TextBuilder color(int col) {
        return this.style(style -> style.color(TextColor.m_131266_((int)col)));
    }

    public TextBuilder color(String hex) {
        return this.style(style -> style.color(Col.fromHex(hex)));
    }

    public TextBuilder color(Color col) {
        return this.style(style -> style.color(col));
    }

    public TextBuilder color(Col col) {
        return this.style(style -> style.color(col));
    }

    public TextBuilder style(UnaryOperator<DotStyle> style) {
        if (!(this.text.m_7383_() instanceof DotStyle)) {
            this.text.m_6270_((Style)DotStyle.of().from(this.text.m_7383_()));
        }
        this.text.m_6270_((Style)style.apply((DotStyle)this.text.m_7383_()));
        return this;
    }

    public TextBuilder text(Component comp) {
        this.text = (MutableComponent)comp;
        return this;
    }

    public TextBuilder text(String comp) {
        this.text = Component.m_237113_((String)comp);
        return this;
    }

    public TextBuilder translatable() {
        this.text = Component.m_237115_((String)this.text.getString());
        return this;
    }

    public TextBuilder effects() {
        return this.style(DotStyle::effects);
    }

    public TextBuilder effects(DotStyle.StyleEffect ... effs) {
        return this.style(s -> s.effects(effs));
    }

    public TextBuilder effects(ResourceLocation ... effs) {
        return this.style(s -> s.effects(effs));
    }

    public TextBuilder render(GuiGraphics g, float x, float y, UnaryOperator<TextRenderProps> props) {
        this.renderStyle(props);
        return this.render(g, x, y);
    }

    public TextBuilder render(GuiGraphics g, float x, float y) {
        GuiDraw d = new GuiDraw(g);
        x += tmp[0];
        y += tmp[1];
        float w = this.width(true);
        float h = this.height(true);
        List<FormattedCharSequence> split = this.split(true);
        if (this.renderProps.xCentered) {
            x -= w / 2.0f;
        }
        if (this.renderProps.yCentered) {
            y -= h / 2.0f;
        }
        d.push();
        d.move(x, y);
        d.scale(this.renderProps.scaleX, this.renderProps.scaleY);
        if (this.renderProps.clipRect != null && this.renderProps.clipRect != AbsRect.ZERO) {
            if (this.renderProps.persistentClip) {
                d.move(-tmp[0], -tmp[1]);
            }
            PoseStack pose = g.m_280168_();
            AbsRect r = this.renderProps.clipRect.pose(pose);
            if (this.renderProps.persistentClip) {
                d.move(tmp[0], tmp[1]);
            }
            float clipx = r.x;
            float clipy = r.y;
            d.scissorsOn((int)clipx, (int)clipy, (int)r.w(), (int)r.h());
        }
        int i = 0;
        for (FormattedCharSequence charseq : split) {
            float locw = Utils.mc().f_91062_.m_92724_(charseq);
            g.drawString(Utils.mc().f_91062_, charseq, this.renderProps.xCentered ? w / 2.0f / this.renderProps.scaleX - locw / 2.0f : 0.0f, (float)(i * 9), Tmp.c1.set(1.0f, 1.0f, 1.0f, this.renderProps.alpha).argb8888(), this.renderProps.shadow);
            ++i;
        }
        if (this.renderProps.clipRect != null && this.renderProps.clipRect != AbsRect.ZERO) {
            d.scissorsOff();
        }
        d.pop();
        return this;
    }

    public TextBuilder next(boolean horizontal, boolean vertical) {
        if (horizontal) {
            tmp[0] = tmp[0] + this.width(true);
        }
        if (vertical) {
            tmp[1] = tmp[1] + this.height(true);
        }
        return this;
    }

    public TextBuilder end() {
        TextBuilder.tmp[1] = 0.0f;
        TextBuilder.tmp[0] = 0.0f;
        return this;
    }

    public static void reset() {
        TextBuilder.tmp[1] = 0.0f;
        TextBuilder.tmp[0] = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float width(boolean useRender) {
        List<FormattedCharSequence> spl = this.split(useRender);
        int max = 0;
        for (FormattedCharSequence ch : spl) {
            int v = Minecraft.m_91087_().f_91062_.m_92724_(ch);
            if (v <= max) continue;
            max = v;
        }
        return (float)max * (useRender ? this.renderProps.scaleX : 1.0f);
    }

    public float height(boolean useRender) {
        return (float)(this.split(useRender).size() * 9) * (useRender ? this.renderProps.scaleY : 1.0f);
    }

    public List<FormattedCharSequence> split(boolean useRender) {
        int maxw = this.renderProps.maxWidth != -1.0f ? (int)(this.renderProps.maxWidth / (useRender ? this.renderProps.scaleX : 1.0f)) : Integer.MAX_VALUE;
        return Utils.mc().f_91062_.m_92923_((FormattedText)this.text, maxw);
    }

    public MutableComponent get() {
        return this.text;
    }
}

