/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.model.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class LuminescentLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public final ResourceLocation location;
    private final float alpha;
    private final float r;
    private final float g;
    private final float b;

    LuminescentLayer(ResourceLocation texture, float alpha, float r, float g, float b, RenderLayerParent<T, M> parent) {
        super(parent);
        this.location = texture;
        this.alpha = alpha;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.renderType());
        this.m_117386_().m_7695_(pPoseStack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, this.r, this.g, this.b, this.alpha);
    }

    @NotNull
    public RenderType renderType() {
        return RenderType.m_234338_((ResourceLocation)this.location);
    }

    public static class Builder<T extends LivingEntity, M extends EntityModel<T>> {
        private ResourceLocation texture;
        private final RenderLayerParent<T, M> parent;
        private float alpha = 1.0f;
        private float r = 1.0f;
        private float g = 1.0f;
        private float b = 1.0f;

        public Builder(RenderLayerParent<T, M> parent) {
            this.parent = parent;
        }

        public Builder<T, M> setTexture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public Builder<T, M> setColor(Color color) {
            this.r = (float)color.getRed() / 255.0f;
            this.g = (float)color.getGreen() / 255.0f;
            this.b = (float)color.getBlue() / 255.0f;
            this.alpha = (float)color.getAlpha() / 255.0f;
            return this;
        }

        public Builder<T, M> setAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder<T, M> setRed(float red) {
            this.r = red;
            return this;
        }

        public Builder<T, M> setGreen(float green) {
            this.g = green;
            return this;
        }

        public Builder<T, M> setBlue(float blue) {
            this.b = blue;
            return this;
        }

        public LuminescentLayer<T, M> build() {
            return new LuminescentLayer<T, M>(this.texture, this.r, this.g, this.b, this.alpha, this.parent);
        }
    }
}

