/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.block;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.model.render.entity.TridotChestRender;
import pro.komaru.tridot.client.model.render.entity.TridotTrappedChestRender;
import pro.komaru.tridot.common.registry.block.TridotBlocks;
import pro.komaru.tridot.common.registry.block.chest.TridotChestBlock;
import pro.komaru.tridot.common.registry.block.chest.TridotTrappedChestBlock;
import pro.komaru.tridot.common.registry.block.entity.TridotChestBlockEntity;
import pro.komaru.tridot.common.registry.block.entity.TridotTrappedChestBlockEntity;
import pro.komaru.tridot.common.registry.block.sign.CustomCeilingHangingSignBlock;
import pro.komaru.tridot.common.registry.block.sign.CustomHangingSignBlockEntity;
import pro.komaru.tridot.common.registry.block.sign.CustomSignBlockEntity;
import pro.komaru.tridot.common.registry.block.sign.CustomStandingSignBlock;
import pro.komaru.tridot.common.registry.block.sign.CustomWallHangingSignBlock;
import pro.komaru.tridot.common.registry.block.sign.CustomWallSignBlock;

public class TridotBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tridot");
    public static final RegistryObject<BlockEntityType<CustomSignBlockEntity>> SIGN = BLOCK_ENTITIES.register("sign", () -> BlockEntityType.Builder.m_155273_(CustomSignBlockEntity::new, (Block[])TridotBlocks.getBlocks(CustomStandingSignBlock.class, CustomWallSignBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<CustomHangingSignBlockEntity>> HANGING_SIGN = BLOCK_ENTITIES.register("hanging_sign", () -> BlockEntityType.Builder.m_155273_(CustomHangingSignBlockEntity::new, (Block[])TridotBlocks.getBlocks(CustomCeilingHangingSignBlock.class, CustomWallHangingSignBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TridotChestBlockEntity>> CHEST_BLOCK_ENTITY = BLOCK_ENTITIES.register("mod_chest", () -> {
        ArrayList<TridotChestBlock> chestBlocks = new ArrayList<TridotChestBlock>();
        for (Map.Entry block : ForgeRegistries.BLOCKS.getEntries()) {
            Object patt2016$temp = block.getValue();
            if (!(patt2016$temp instanceof TridotChestBlock)) continue;
            TridotChestBlock chestBlock = (TridotChestBlock)((Object)((Object)patt2016$temp));
            if (!chestBlock.autoReg) continue;
            chestBlocks.add(chestBlock);
        }
        return BlockEntityType.Builder.m_155273_(TridotChestBlockEntity::new, (Block[])chestBlocks.toArray(new Block[0])).m_58966_(null);
    });
    public static final RegistryObject<BlockEntityType<TridotTrappedChestBlockEntity>> TRAPPED_CHEST_BLOCK_ENTITY = BLOCK_ENTITIES.register("mod_trapped_chest", () -> {
        ArrayList<TridotTrappedChestBlock> chestBlocks = new ArrayList<TridotTrappedChestBlock>();
        for (Map.Entry block : ForgeRegistries.BLOCKS.getEntries()) {
            Object patt2585$temp = block.getValue();
            if (!(patt2585$temp instanceof TridotTrappedChestBlock)) continue;
            TridotTrappedChestBlock chestBlock = (TridotTrappedChestBlock)((Object)((Object)patt2585$temp));
            if (!chestBlock.autoReg) continue;
            chestBlocks.add(chestBlock);
        }
        return BlockEntityType.Builder.m_155273_(TridotTrappedChestBlockEntity::new, (Block[])chestBlocks.toArray(new Block[0])).m_58966_(null);
    });

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITIES.register(eventBus);
    }

    @Mod.EventBusSubscriber(modid="tridot", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientRegistryEvents {
        @SubscribeEvent
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SIGN.get()), SignRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)HANGING_SIGN.get()), HangingSignRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CHEST_BLOCK_ENTITY.get()), TridotChestRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TRAPPED_CHEST_BLOCK_ENTITY.get()), TridotTrappedChestRender::new);
        }
    }
}

