/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.system;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSelector;

public interface AttackSystemMob {
    public static final String NBT_COOLDOWNS_KEY = "AttackCooldowns";
    public static final String NBT_CURRENT_ATTACK_KEY = "AttackCooldowns";

    public AttackSelector getAttackSelector();

    public AttackInstance getActiveAttack();

    public void setActiveAttack(AttackInstance var1);

    default public boolean isPreparingAttack() {
        return this.getActiveAttack() != null;
    }

    default public void readAttackInfo(CompoundTag pCompound) {
        String attackId;
        CompoundTag tag;
        if (pCompound.m_128441_("AttackCooldowns")) {
            tag = pCompound.m_128469_("AttackCooldowns");
            for (AttackInstance attack : this.getAttackSelector().attacks) {
                attackId = attack.getId().toString();
                if (!tag.m_128441_(attackId)) continue;
                this.setActiveAttack(attack);
            }
        }
        if (pCompound.m_128441_("AttackCooldowns")) {
            tag = pCompound.m_128469_("AttackCooldowns");
            for (AttackInstance attack : this.getAttackSelector().attacks) {
                attackId = attack.getId().toString();
                if (!tag.m_128441_(attackId)) continue;
                attack.cooldownTimer = tag.m_128451_(attackId);
            }
        }
    }

    default public void writeAttackInfo(CompoundTag pCompound) {
        CompoundTag tag = new CompoundTag();
        for (AttackInstance attack : this.getAttackSelector().attacks) {
            if (!attack.isOnCooldown()) continue;
            tag.m_128405_(attack.getId().toString(), attack.cooldownTimer);
        }
        if (this.getActiveAttack() != null) {
            pCompound.m_128359_("AttackCooldowns", this.getActiveAttack().getId().toString());
        }
        if (!tag.m_128456_()) {
            pCompound.m_128365_("AttackCooldowns", (Tag)tag);
        }
    }

    default public void tickCooldowns() {
        this.getAttackSelector().attacks.forEach(attackInstance -> {
            if (attackInstance.cooldownTimer > 0) {
                --attackInstance.cooldownTimer;
            }
        });
    }
}

