/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.system;

import java.util.EnumSet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;

public class ExecuteAttackGoal
extends Goal {
    private final PathfinderMob mob;
    private final AttackSystemMob attackableMob;
    private LivingEntity target;
    private AttackInstance chosenAttack;
    private State currentState = State.IDLE;
    private int timer;

    public ExecuteAttackGoal(PathfinderMob mob) {
        this.mob = mob;
        if (!(mob instanceof AttackSystemMob)) {
            throw new IllegalArgumentException("Mob must implement IAttackableMob!");
        }
        this.attackableMob = (AttackSystemMob)mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.chosenAttack == null) {
            this.chosenAttack = this.attackableMob.getAttackSelector().selectAttack(this.mob, target);
        }
        return this.chosenAttack != null;
    }

    public void m_8056_() {
        this.target = this.mob.m_5448_();
        this.attackableMob.setActiveAttack(this.chosenAttack);
        this.currentState = State.PREPARING;
        this.timer = this.chosenAttack.attackDelay;
        this.chosenAttack.start(this.attackableMob);
        Level level = this.mob.m_9236_();
        if (level != null) {
            level.m_5594_(null, this.mob.m_20183_(), this.chosenAttack.getPrepareSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void m_8041_() {
        if (this.chosenAttack != null) {
            this.chosenAttack.setAttackOnCooldown();
        }
        this.chosenAttack = null;
        this.attackableMob.setActiveAttack(null);
        this.target = null;
        this.currentState = State.IDLE;
        this.timer = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null || !this.target.m_6084_() || this.chosenAttack == null) {
            this.m_8041_();
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        --this.timer;
        switch (this.currentState) {
            case PREPARING: {
                if (!this.chosenAttack.canUse(this.target)) {
                    this.m_8041_();
                    return;
                }
                if (this.timer > 0) break;
                this.currentState = State.EXECUTING;
                this.timer = this.chosenAttack.attackDuration;
                this.chosenAttack.performAttack();
                Level level = this.mob.m_9236_();
                if (level == null) break;
                level.m_5594_(null, this.mob.m_20183_(), this.chosenAttack.getAttackSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
                break;
            }
            case EXECUTING: {
                if (this.timer > 0) break;
                this.m_8041_();
            }
        }
    }

    private static enum State {
        IDLE,
        PREPARING,
        EXECUTING;

    }
}

