/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.mixin.client.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import pro.komaru.tridot.client.tooltip.AttributeTooltipModifier;
import pro.komaru.tridot.client.tooltip.TooltipModifierHandler;
import top.theillusivec4.curios.client.ClientEventHandler;

@Mixin(value={ClientEventHandler.class})
public abstract class CurioTooltipMixin
implements IMixinConfigPlugin {
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith("top.theillusivec4.curios.client.ClientEventHandler")) {
            return ModList.get().isLoaded("curios");
        }
        return false;
    }

    @ModifyVariable(method={"onTooltip"}, at=@At(value="STORE"), remap=false)
    public Multimap<Attribute, AttributeModifier> tridot$getTooltip(Multimap<Attribute, AttributeModifier> multimap, ItemTooltipEvent event) {
        if (event != null && multimap != null) {
            LinkedHashMultimap copied = LinkedHashMultimap.create();
            for (Map.Entry entry : multimap.entries()) {
                Attribute key = (Attribute)entry.getKey();
                if (key == null) continue;
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double amount = modifier.m_22218_();
                boolean flagAdd = false;
                AttributeModifier.Operation operation = modifier.m_22217_();
                for (AttributeTooltipModifier tooltipModifier : TooltipModifierHandler.getModifiers()) {
                    if (!tooltipModifier.isModifiable(key, modifier, event.getEntity(), event.getFlags())) continue;
                    AttributeTooltipModifier.ModifyResult result = tooltipModifier.modify(modifier, amount, operation);
                    modifier = result.getModifier();
                    amount = result.getAmount();
                    operation = result.getOperation();
                    flagAdd = true;
                    break;
                }
                if (flagAdd) {
                    copied.put((Object)key, (Object)new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), amount, operation));
                    continue;
                }
                copied.put((Object)key, (Object)modifier);
            }
            return copied;
        }
        return multimap;
    }
}

