/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util;

import java.awt.Color;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.phys.Vec3;

public class Col {
    public float r;
    public float g;
    public float b;
    public float a;
    private static final float[] tmpHSV = new float[3];
    public static Col white = new Col(1.0f, 1.0f, 1.0f, 1.0f);
    public static Col lightGray = new Col(192, 192, 192);
    public static Col gray = new Col(64, 64, 64);
    public static Col darkGray = new Col(64, 64, 64);
    public static Col black = new Col(0, 0, 0);
    public static Col red = new Col(255, 0, 0);
    public static Col pink = new Col(255, 175, 175);
    public static Col orange = new Col(255, 200, 0);
    public static Col yellow = new Col(255, 255, 0);
    public static Col green = new Col(0, 255, 0);
    public static Col magenta = new Col(255, 0, 255);
    public static Col cyan = new Col(0, 255, 255);
    public static Col blue = new Col(0, 0, 255);

    public static Color getColor(int color) {
        return new Color(Col.getRed(color), Col.getGreen(color), Col.getBlue(color), Col.getAlpha(color));
    }

    public TextColor toTextColor() {
        return TextColor.m_131266_((int)this.toARGB());
    }

    public int toARGB() {
        return Col.intArgb(this);
    }

    public Color toJava() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public Col darker() {
        return this.set(Math.max(this.r * 0.7f, 0.0f), Math.max(this.g * 0.7f, 0.0f), Math.max(this.b * 0.7f, 0.0f));
    }

    public Col brighter() {
        int i = 3;
        if (this.r == 0.0f && this.g == 0.0f && this.b == 0.0f) {
            return new Col(i, i, i, 1.0f);
        }
        if (this.r > 0.0f && this.r < (float)i) {
            this.r = i;
        }
        if (this.g > 0.0f && this.g < (float)i) {
            this.g = i;
        }
        if (this.b > 0.0f && this.b < (float)i) {
            this.b = i;
        }
        return this.set(Math.min(this.r / 0.7f, 1.0f), Math.min(this.g / 0.7f, 1.0f), Math.min(this.b / 0.7f, 1.0f));
    }

    public static int intArgb(Col color) {
        String rrggbbaa = color.toString();
        String rr = rrggbbaa.substring(0, 2);
        String gg = rrggbbaa.substring(2, 4);
        String bb = rrggbbaa.substring(4, 6);
        String aa = rrggbbaa.substring(6, 8);
        String aarrggbb = aa + rr + gg + bb;
        int colorInt = (int)Long.parseLong(aarrggbb, 16);
        return colorInt;
    }

    public static Col fromARGB(int aarrggbb) {
        Col col = new Col(aarrggbb);
        return new Col(col.g, col.b, col.a, col.r);
    }

    public static int intArgb(String str) {
        return Col.intArgb(Col.fromHex(str));
    }

    public static float relativeLuminance(int colorCode) {
        Col color = new Col(colorCode);
        float r = (double)color.r <= 0.03928 ? color.r / 12.92f : (float)Math.pow(((double)color.r + 0.055) / 1.055, 2.4);
        float g = (double)color.g <= 0.03928 ? color.g / 12.92f : (float)Math.pow(((double)color.g + 0.055) / 1.055, 2.4);
        float b = (double)color.b <= 0.03928 ? color.b / 12.92f : (float)Math.pow(((double)color.b + 0.055) / 1.055, 2.4);
        return 0.2126f * r + 0.7152f * g + 0.0722f * b;
    }

    public static float chatContrast(int color) {
        return Col.contrast(color, 4937320);
    }

    public static float contrast(int first, int second) {
        return (float)(((double)Col.relativeLuminance(first) + 0.05) / ((double)Col.relativeLuminance(second) + 0.05));
    }

    public Col(Col color) {
        this.set(color);
    }

    public static Col fromColor(Color color) {
        return new Col(color.getRGB());
    }

    public Col(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.clamp();
    }

    public Col(int rgba8888) {
        this.rgba8888(rgba8888);
    }

    public Col mul(Col color) {
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        this.a *= color.a;
        return this.clamp();
    }

    public Col mul(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        return this.clamp();
    }

    public Col mula(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        this.a *= value;
        return this.clamp();
    }

    public Col a(float alpha) {
        return new Col(this.r, this.g, this.b, alpha);
    }

    public Col add(Col color) {
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        return this.clamp();
    }

    public Col sub(Col color) {
        this.r -= color.r;
        this.g -= color.g;
        this.b -= color.b;
        return this.clamp();
    }

    public Col clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        } else if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        } else if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        } else if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        } else if (this.a > 1.0f) {
            this.a = 1.0f;
        }
        return this;
    }

    public static int rgba8888(float r, float g, float b, float a) {
        return (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
    }

    public static int argb8888(float a, float r, float g, float b) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public int rgba8888() {
        return (int)(this.r * 255.0f) << 24 | (int)(this.g * 255.0f) << 16 | (int)(this.b * 255.0f) << 8 | (int)(this.a * 255.0f);
    }

    public int argb8888() {
        return (int)(this.a * 255.0f) << 24 | (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    public Col rgba8888(int value) {
        this.r = (float)((value & 0xFF000000) >>> 24) / 255.0f;
        this.g = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        this.b = (float)((value & 0xFF00) >>> 8) / 255.0f;
        this.a = (float)(value & 0xFF) / 255.0f;
        return this;
    }

    public Col set(Col color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Col set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this.clamp();
    }

    public Col set(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this.clamp();
    }

    public Col set(int rgba) {
        return this.rgba8888(rgba);
    }

    public Col lerp(Col target, float t) {
        this.r += t * (target.r - this.r);
        this.g += t * (target.g - this.g);
        this.b += t * (target.b - this.b);
        this.a += t * (target.a - this.a);
        return this.clamp();
    }

    public Col lerp(float r, float g, float b, float a, float t) {
        this.r += t * (r - this.r);
        this.g += t * (g - this.g);
        this.b += t * (b - this.b);
        this.a += t * (a - this.a);
        return this.clamp();
    }

    public Col fromHsv(float[] hsv) {
        return this.fromHsv(hsv[0], hsv[1], hsv[2]);
    }

    public Col fromHsv(float h, float s, float v) {
        float x = (h / 60.0f + 6.0f) % 6.0f;
        int i = (int)x;
        float f = x - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                this.r = v;
                this.g = t;
                this.b = p;
                break;
            }
            case 1: {
                this.r = q;
                this.g = v;
                this.b = p;
                break;
            }
            case 2: {
                this.r = p;
                this.g = v;
                this.b = t;
                break;
            }
            case 3: {
                this.r = p;
                this.g = q;
                this.b = v;
                break;
            }
            case 4: {
                this.r = t;
                this.g = p;
                this.b = v;
                break;
            }
            default: {
                this.r = v;
                this.g = p;
                this.b = q;
            }
        }
        return this.clamp();
    }

    public float[] toHsv(float[] hsv) {
        float min;
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float range = max - (min = Math.min(Math.min(this.r, this.g), this.b));
        hsv[0] = range == 0.0f ? 0.0f : (max == this.r ? (60.0f * (this.g - this.b) / range + 360.0f) % 360.0f : (max == this.g ? 60.0f * (this.b - this.r) / range + 120.0f : 60.0f * (this.r - this.g) / range + 240.0f));
        hsv[1] = max > 0.0f ? 1.0f - min / max : 0.0f;
        hsv[2] = max;
        return hsv;
    }

    public static Col HSVtoRGB(float h, float s, float v, float alpha) {
        Col c = Col.HSVtoRGB(h, s, v);
        c.a = alpha;
        return c;
    }

    public static Col HSVtoRGB(float h, float s, float v) {
        Col c = new Col(1.0f, 1.0f, 1.0f, 1.0f);
        Col.HSVtoRGB(h, s, v, c);
        return c;
    }

    public static void HSVtoRGB(float h, float s, float v, Col targetColor) {
        float g;
        float r;
        if (h == 360.0f) {
            h = 359.0f;
        }
        h = (float)Math.max(0.0, Math.min(360.0, (double)h));
        s = (float)Math.max(0.0, Math.min(100.0, (double)s));
        v = (float)Math.max(0.0, Math.min(100.0, (double)v));
        int i = (int)Math.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = (v /= 100.0f) * (1.0f - (s /= 100.0f));
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        targetColor.set(r, g, switch (i) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        }, targetColor.a);
    }

    public static int[] RGBtoHSV(Col c) {
        return Col.RGBtoHSV(c.r, c.g, c.b);
    }

    public static int[] RGBtoHSV(float r, float g, float b) {
        float max;
        float min = Math.min(Math.min(r, g), b);
        float v = max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = 0.0f;
            return new int[]{Math.round(h), Math.round(s), Math.round(v)};
        }
        float s = delta / max;
        float h = delta == 0.0f ? 0.0f : (r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta));
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        return new int[]{Math.round(h), Math.round(s *= 100.0f), Math.round(v *= 100.0f)};
    }

    public Col copy() {
        return new Col(this);
    }

    public Col hue(float amount) {
        this.toHsv(tmpHSV);
        Col.tmpHSV[0] = amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col sat(float amount) {
        this.toHsv(tmpHSV);
        Col.tmpHSV[1] = amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col value(float amount) {
        this.toHsv(tmpHSV);
        Col.tmpHSV[2] = amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col shiftHue(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[0] = tmpHSV[0] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col shiftSat(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[1] = tmpHSV[1] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col shiftValue(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[2] = tmpHSV[2] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Col(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Col(int r, int g, int b) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public int red() {
        return this.rgb() >> 16 & 0xFF;
    }

    public int green() {
        return this.rgb() >> 8 & 0xFF;
    }

    public int blue() {
        return this.rgb() & 0xFF;
    }

    public int alpha() {
        return this.rgb() >> 24 & 0xFF;
    }

    public int rgb() {
        return this.rgba();
    }

    public int rgba() {
        return (int)(this.a * 255.0f) << 24 | (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    public static int alpha(int packedColor) {
        return packedColor >>> 24;
    }

    public static int red(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    public static int green(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    public static int blue(int packedColor) {
        return packedColor & 0xFF;
    }

    public static int pack(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int pack(float red, float green, float blue) {
        return ((int)(red * 255.0f) & 0xFF) << 16 | ((int)(green * 255.0f) & 0xFF) << 8 | (int)(blue * 255.0f) & 0xFF;
    }

    public static int pack(float alpha, float red, float green, float blue) {
        return ((int)(alpha * 255.0f) & 0xFF) << 24 | ((int)(red * 255.0f) & 0xFF) << 16 | ((int)(green * 255.0f) & 0xFF) << 8 | (int)(blue * 255.0f) & 0xFF;
    }

    public int pack() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public static int toDecimal(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static int toDecimal(Col color) {
        return Integer.parseInt(Col.hex(color), 16);
    }

    public int toDecimal() {
        return Integer.parseInt(this.hex(), 16);
    }

    public static String hex(Col color) {
        Object hex = Integer.toHexString(color.rgb() & 0xFFFFFF);
        if (((String)hex).length() < 6) {
            hex = "0" + (String)hex;
        }
        return hex;
    }

    public static String hex(Color color) {
        Object hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        if (((String)hex).length() < 6) {
            hex = "0" + (String)hex;
        }
        return hex;
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        this.toString(value);
        return value.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append(Integer.toHexString((int)(255.0f * this.r) << 24 | (int)(255.0f * this.g) << 16 | (int)(255.0f * this.b) << 8 | (int)(255.0f * this.a)));
        while (builder.length() < 8) {
            builder.insert(0, "0");
        }
    }

    public static Col fromHex(String hex) {
        int offset = hex.charAt(0) == '#' ? 1 : 0;
        int r = Col.parseHex(hex, offset, offset + 2);
        int g = Col.parseHex(hex, offset + 2, offset + 4);
        int b = Col.parseHex(hex, offset + 4, offset + 6);
        int a = hex.length() - offset != 8 ? 255 : Col.parseHex(hex, offset + 6, offset + 8);
        return new Col((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static int getAlpha(int packedColor) {
        return packedColor >>> 24;
    }

    public static int getRed(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    public static int getGreen(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    public static int getBlue(int packedColor) {
        return packedColor & 0xFF;
    }

    public static int packColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int packColor(float red, float green, float blue) {
        return ((int)(red * 255.0f) & 0xFF) << 16 | ((int)(green * 255.0f) & 0xFF) << 8 | (int)(blue * 255.0f) & 0xFF;
    }

    public static int packColor(float alpha, float red, float green, float blue) {
        return ((int)(alpha * 255.0f) & 0xFF) << 24 | ((int)(red * 255.0f) & 0xFF) << 16 | ((int)(green * 255.0f) & 0xFF) << 8 | (int)(blue * 255.0f) & 0xFF;
    }

    public static int packColor(Color color) {
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static Col rainbow(float ticks) {
        return Col.HSVtoRGB(ticks % 360.0f, 100.0f, 100.0f);
    }

    public static int hexToDecimal(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static int colorToDecimal(Color color) {
        return Integer.parseInt(Col.hex(color), 16);
    }

    public static Vec3 toVec3(Color color) {
        return new Vec3((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }

    public String hex() {
        Object hex = Integer.toHexString(this.rgb() & 0xFFFFFF);
        if (((String)hex).length() < 6) {
            hex = "0" + (String)hex;
        }
        return hex;
    }

    private static int parseHex(String string, int from, int to) {
        int total = 0;
        for (int i = from; i < to; ++i) {
            char c = string.charAt(i);
            total += Character.digit(c, 16) * (i == from ? 16 : 1);
        }
        return total;
    }
}

