/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.math;

import java.util.Random;

public class ArcRandom
extends Random {
    private static final double NORM_DOUBLE = (double)1.110223E-16f;
    private static final double NORM_FLOAT = 5.960464477539063E-8;
    public long seed0;
    public long seed1;

    public ArcRandom() {
        this.setSeed(new Random().nextLong());
    }

    public ArcRandom(long seed) {
        this.setSeed(seed);
    }

    public ArcRandom(long seed0, long seed1) {
        this.setState(seed0, seed1);
    }

    private static long murmurHash3(long x) {
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        x *= -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    @Override
    public long nextLong() {
        long s0;
        long s1 = this.seed0;
        this.seed0 = s0 = this.seed1;
        s1 ^= s1 << 23;
        this.seed1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        return this.seed1 + s0;
    }

    @Override
    protected final int next(int bits) {
        return (int)(this.nextLong() & (1L << bits) - 1L);
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        long value;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((bits = this.nextLong() >>> 1) - (value = bits % n) + (n - 1L) < 0L) {
        }
        return value;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)((double)(this.nextLong() >>> 40) * 5.960464477539063E-8);
    }

    @Override
    public boolean nextBoolean() {
        return (this.nextLong() & 1L) != 0L;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (i != 0) {
            int n = i < 8 ? i : 8;
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        long seed0 = ArcRandom.murmurHash3(seed == 0L ? Long.MIN_VALUE : seed);
        this.setState(seed0, ArcRandom.murmurHash3(seed0));
    }

    public boolean fiftyFifty() {
        return this.nextBoolean();
    }

    public boolean chance(int chance) {
        return this.nextInt() < chance;
    }

    public boolean chance(double chance) {
        return this.nextDouble() < chance;
    }

    public boolean chance(float chance) {
        return this.nextFloat() < chance;
    }

    public float range(float amount) {
        return this.nextFloat() * amount * 2.0f - amount;
    }

    public float random(float max) {
        return this.nextFloat() * max;
    }

    public int random(int max) {
        return this.nextInt(max + 1);
    }

    public float random(float min, float max) {
        return min + (max - min) * this.nextFloat();
    }

    public int range(int amount) {
        return this.nextInt(amount * 2 + 1) - amount;
    }

    public int random(int min, int max) {
        if (min >= max) {
            return min;
        }
        return min + this.nextInt(max - min + 1);
    }

    public int randomNumberUpTo(int upperBound) {
        return this.nextInt(upperBound);
    }

    public float randomValueUpTo(float upperBound) {
        return this.nextFloat() * upperBound;
    }

    public double randomValueUpTo(double upperBound) {
        return this.nextDouble() * upperBound;
    }

    public void setState(long seed0, long seed1) {
        this.seed0 = seed0;
        this.seed1 = seed1;
    }

    public long getState(int seed) {
        return seed == 0 ? this.seed0 : this.seed1;
    }
}

