/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.struct.wraps;

import pro.komaru.tridot.util.math.Mathf;
import pro.komaru.tridot.util.struct.func.Func;
import pro.komaru.tridot.util.struct.func.Prov;

public class RangeClamp {
    public Prov<Integer> min;
    public Prov<Integer> max;
    public int current;

    public RangeClamp(Prov<Integer> min, Prov<Integer> max) {
        this.min = min;
        this.max = max;
        this.current = min.get();
    }

    public void update(Func<Integer, Integer> f) {
        this.current = Mathf.clamp(f.get(this.current), this.min.get(), this.max.get());
    }

    public int current() {
        return this.current;
    }

    public boolean peek() {
        return this.current + 1 < this.max.get();
    }

    public boolean next() {
        if (!this.peek()) {
            return false;
        }
        ++this.current;
        return true;
    }

    public boolean peekBack() {
        return this.current - 1 >= this.min.get();
    }

    public boolean back() {
        if (!this.peekBack()) {
            return false;
        }
        --this.current;
        return true;
    }

    public boolean peekCurrent() {
        return this.current >= this.min.get() && this.current < this.max.get();
    }
}

