/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger f_18797_ = LogUtils.getLogger();
    private static final ThreadFactory f_18798_ = new ThreadFactoryBuilder().setDaemon(true).build();
    private final Registry<LevelStem> f_243889_;
    private final Set<ResourceKey<Level>> f_243666_;
    private final boolean f_18800_;
    private final LevelStorageSource.LevelStorageAccess f_18801_;
    private final Thread f_18802_;
    private final DataFixer f_18803_;
    private volatile boolean f_18804_ = true;
    private volatile boolean f_18805_;
    private volatile float f_18806_;
    private volatile int f_18807_;
    private volatile int f_18808_;
    private volatile int f_18809_;
    private final Object2FloatMap<ResourceKey<Level>> f_18810_ = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.m_137583_()));
    private volatile Component f_18811_ = Component.m_237115_("optimizeWorld.stage.counting");
    private static final Pattern f_18812_ = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionDataStorage f_18813_;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess p_249922_, DataFixer p_250273_, Registry<LevelStem> p_252191_, boolean p_250738_) {
        this.f_243889_ = p_252191_;
        this.f_243666_ = p_252191_.m_214010_().stream().map(Registries::m_257551_).collect(Collectors.toUnmodifiableSet());
        this.f_18800_ = p_250738_;
        this.f_18803_ = p_250273_;
        this.f_18801_ = p_249922_;
        this.f_18813_ = new DimensionDataStorage(this.f_18801_.m_197394_(Level.f_46428_).resolve("data").toFile(), p_250273_);
        this.f_18802_ = f_18798_.newThread(this::m_18838_);
        this.f_18802_.setUncaughtExceptionHandler((p_18825_, p_18826_) -> {
            f_18797_.error("Error upgrading world", p_18826_);
            this.f_18811_ = Component.m_237115_("optimizeWorld.stage.failed");
            this.f_18805_ = true;
        });
        this.f_18802_.start();
    }

    public void m_18820_() {
        this.f_18804_ = false;
        try {
            this.f_18802_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void m_18838_() {
        this.f_18807_ = 0;
        ImmutableMap.Builder $$0 = ImmutableMap.builder();
        for (ResourceKey<Level> $$1 : this.f_243666_) {
            List<ChunkPos> $$2 = this.m_18830_($$1);
            $$0.put($$1, $$2.listIterator());
            this.f_18807_ += $$2.size();
        }
        if (this.f_18807_ == 0) {
            this.f_18805_ = true;
            return;
        }
        float $$3 = this.f_18807_;
        ImmutableMap $$4 = $$0.build();
        ImmutableMap.Builder $$5 = ImmutableMap.builder();
        for (ResourceKey<Level> $$6 : this.f_243666_) {
            Path $$7 = this.f_18801_.m_197394_($$6);
            $$5.put($$6, (Object)new ChunkStorage($$7.resolve("region"), this.f_18803_, true));
        }
        ImmutableMap $$8 = $$5.build();
        long $$9 = Util.m_137550_();
        this.f_18811_ = Component.m_237115_("optimizeWorld.stage.upgrading");
        while (this.f_18804_) {
            boolean $$10 = false;
            float $$11 = 0.0f;
            for (ResourceKey<Level> $$12 : this.f_243666_) {
                ListIterator $$13 = (ListIterator)$$4.get($$12);
                ChunkStorage $$14 = (ChunkStorage)$$8.get($$12);
                if ($$13.hasNext()) {
                    ChunkPos $$15 = (ChunkPos)$$13.next();
                    boolean $$16 = false;
                    try {
                        CompoundTag $$17 = $$14.m_223454_($$15).join().orElse(null);
                        if ($$17 != null) {
                            boolean $$22;
                            int $$18 = ChunkStorage.m_63505_($$17);
                            ChunkGenerator $$19 = this.f_243889_.m_123013_(Registries.m_257452_($$12)).f_63976_();
                            CompoundTag $$20 = $$14.m_188288_($$12, () -> this.f_18813_, $$17, $$19.m_187743_());
                            ChunkPos $$21 = new ChunkPos($$20.m_128451_("xPos"), $$20.m_128451_("zPos"));
                            if (!$$21.equals($$15)) {
                                f_18797_.warn("Chunk {} has invalid position {}", (Object)$$15, (Object)$$21);
                            }
                            boolean bl = $$22 = $$18 < SharedConstants.m_183709_().m_183476_().m_193006_();
                            if (this.f_18800_) {
                                $$22 = $$22 || $$20.m_128441_("Heightmaps");
                                $$20.m_128473_("Heightmaps");
                                $$22 = $$22 || $$20.m_128441_("isLightOn");
                                $$20.m_128473_("isLightOn");
                                ListTag $$23 = $$20.m_128437_("sections", 10);
                                for (int $$24 = 0; $$24 < $$23.size(); ++$$24) {
                                    CompoundTag $$25 = $$23.m_128728_($$24);
                                    $$22 = $$22 || $$25.m_128441_("BlockLight");
                                    $$25.m_128473_("BlockLight");
                                    $$22 = $$22 || $$25.m_128441_("SkyLight");
                                    $$25.m_128473_("SkyLight");
                                }
                            }
                            if ($$22) {
                                $$14.m_63502_($$15, $$20);
                                $$16 = true;
                            }
                        }
                    }
                    catch (CompletionException | ReportedException $$26) {
                        Throwable $$27 = $$26.getCause();
                        if ($$27 instanceof IOException) {
                            f_18797_.error("Error upgrading chunk {}", (Object)$$15, (Object)$$27);
                        }
                        throw $$26;
                    }
                    if ($$16) {
                        ++this.f_18808_;
                    } else {
                        ++this.f_18809_;
                    }
                    $$10 = true;
                }
                float $$28 = (float)$$13.nextIndex() / $$3;
                this.f_18810_.put($$12, $$28);
                $$11 += $$28;
            }
            this.f_18806_ = $$11;
            if ($$10) continue;
            this.f_18804_ = false;
        }
        this.f_18811_ = Component.m_237115_("optimizeWorld.stage.finished");
        for (ChunkStorage $$29 : $$8.values()) {
            try {
                $$29.close();
            }
            catch (IOException $$30) {
                f_18797_.error("Error upgrading chunk", (Throwable)$$30);
            }
        }
        this.f_18813_.m_78151_();
        $$9 = Util.m_137550_() - $$9;
        f_18797_.info("World optimizaton finished after {} ms", (Object)$$9);
        this.f_18805_ = true;
    }

    private List<ChunkPos> m_18830_(ResourceKey<Level> p_18831_) {
        File $$1 = this.f_18801_.m_197394_(p_18831_).toFile();
        File $$2 = new File($$1, "region");
        File[] $$3 = $$2.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if ($$3 == null) {
            return ImmutableList.of();
        }
        ArrayList $$4 = Lists.newArrayList();
        for (File $$5 : $$3) {
            Matcher $$6 = f_18812_.matcher($$5.getName());
            if (!$$6.matches()) continue;
            int $$7 = Integer.parseInt($$6.group(1)) << 5;
            int $$8 = Integer.parseInt($$6.group(2)) << 5;
            try (RegionFile $$9 = new RegionFile($$5.toPath(), $$2.toPath(), true);){
                for (int $$10 = 0; $$10 < 32; ++$$10) {
                    for (int $$11 = 0; $$11 < 32; ++$$11) {
                        ChunkPos $$12 = new ChunkPos($$10 + $$7, $$11 + $$8);
                        if (!$$9.m_63673_($$12)) continue;
                        $$4.add($$12);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return $$4;
    }

    public boolean m_18829_() {
        return this.f_18805_;
    }

    public Set<ResourceKey<Level>> m_246941_() {
        return this.f_243666_;
    }

    public float m_18827_(ResourceKey<Level> p_18828_) {
        return this.f_18810_.getFloat(p_18828_);
    }

    public float m_18833_() {
        return this.f_18806_;
    }

    public int m_18834_() {
        return this.f_18807_;
    }

    public int m_18835_() {
        return this.f_18808_;
    }

    public int m_18836_() {
        return this.f_18809_;
    }

    public Component m_18837_() {
        return this.f_18811_;
    }
}

