/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.freetype.FT_Parameter;
import org.lwjgl.util.freetype.FT_Stream;

public class FT_Open_Args
extends Struct<FT_Open_Args>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int MEMORY_BASE;
    public static final int MEMORY_SIZE;
    public static final int PATHNAME;
    public static final int STREAM;
    public static final int DRIVER;
    public static final int NUM_PARAMS;
    public static final int PARAMS;

    protected FT_Open_Args(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Open_Args create(long address, @Nullable ByteBuffer container) {
        return new FT_Open_Args(address, container);
    }

    public FT_Open_Args(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Open_Args.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_UInt")
    public int flags() {
        return FT_Open_Args.nflags(this.address());
    }

    @NativeType(value="FT_Byte const *")
    public @Nullable ByteBuffer memory_base() {
        return FT_Open_Args.nmemory_base(this.address());
    }

    @NativeType(value="FT_Long")
    public long memory_size() {
        return FT_Open_Args.nmemory_size(this.address());
    }

    @NativeType(value="FT_String *")
    public @Nullable ByteBuffer pathname() {
        return FT_Open_Args.npathname(this.address());
    }

    @NativeType(value="FT_String *")
    public @Nullable String pathnameString() {
        return FT_Open_Args.npathnameString(this.address());
    }

    public @Nullable FT_Stream stream$() {
        return FT_Open_Args.nstream$(this.address());
    }

    @NativeType(value="FT_Module")
    public long driver() {
        return FT_Open_Args.ndriver(this.address());
    }

    @NativeType(value="FT_Int")
    public int num_params() {
        return FT_Open_Args.nnum_params(this.address());
    }

    @NativeType(value="FT_Parameter *")
    public @Nullable FT_Parameter.Buffer params() {
        return FT_Open_Args.nparams(this.address());
    }

    public FT_Open_Args flags(@NativeType(value="FT_UInt") int value) {
        FT_Open_Args.nflags(this.address(), value);
        return this;
    }

    public FT_Open_Args memory_base(@NativeType(value="FT_Byte const *") @Nullable ByteBuffer value) {
        FT_Open_Args.nmemory_base(this.address(), value);
        return this;
    }

    public FT_Open_Args memory_size(@NativeType(value="FT_Long") long value) {
        FT_Open_Args.nmemory_size(this.address(), value);
        return this;
    }

    public FT_Open_Args pathname(@NativeType(value="FT_String *") @Nullable ByteBuffer value) {
        FT_Open_Args.npathname(this.address(), value);
        return this;
    }

    public FT_Open_Args stream$(@Nullable FT_Stream value) {
        FT_Open_Args.nstream$(this.address(), value);
        return this;
    }

    public FT_Open_Args driver(@NativeType(value="FT_Module") long value) {
        FT_Open_Args.ndriver(this.address(), value);
        return this;
    }

    public FT_Open_Args num_params(@NativeType(value="FT_Int") int value) {
        FT_Open_Args.nnum_params(this.address(), value);
        return this;
    }

    public FT_Open_Args params(@NativeType(value="FT_Parameter *") @Nullable FT_Parameter.Buffer value) {
        FT_Open_Args.nparams(this.address(), value);
        return this;
    }

    public FT_Open_Args set(int flags, @Nullable ByteBuffer memory_base, long memory_size, @Nullable ByteBuffer pathname, @Nullable FT_Stream stream$, long driver, int num_params, @Nullable FT_Parameter.Buffer params) {
        this.flags(flags);
        this.memory_base(memory_base);
        this.memory_size(memory_size);
        this.pathname(pathname);
        this.stream$(stream$);
        this.driver(driver);
        this.num_params(num_params);
        this.params(params);
        return this;
    }

    public FT_Open_Args set(FT_Open_Args src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FT_Open_Args malloc() {
        return new FT_Open_Args(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_Open_Args calloc() {
        return new FT_Open_Args(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_Open_Args create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_Open_Args(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_Open_Args create(long address) {
        return new FT_Open_Args(address, null);
    }

    public static @Nullable FT_Open_Args createSafe(long address) {
        return address == 0L ? null : new FT_Open_Args(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_Open_Args.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_Open_Args.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_Open_Args malloc(MemoryStack stack) {
        return new FT_Open_Args(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_Open_Args calloc(MemoryStack stack) {
        return new FT_Open_Args(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static @Nullable ByteBuffer nmemory_base(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MEMORY_BASE)), (int)((int)FT_Open_Args.nmemory_size(struct)));
    }

    public static long nmemory_size(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)MEMORY_SIZE));
    }

    public static @Nullable ByteBuffer npathname(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PATHNAME)));
    }

    public static @Nullable String npathnameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PATHNAME)));
    }

    public static @Nullable FT_Stream nstream$(long struct) {
        return FT_Stream.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)STREAM)));
    }

    public static long ndriver(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DRIVER));
    }

    public static int nnum_params(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_PARAMS));
    }

    public static @Nullable FT_Parameter.Buffer nparams(long struct) {
        return FT_Parameter.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PARAMS)), FT_Open_Args.nnum_params(struct));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nmemory_base(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEMORY_BASE), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        FT_Open_Args.nmemory_size(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void nmemory_size(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)MEMORY_SIZE), (long)value);
    }

    public static void npathname(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PATHNAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nstream$(long struct, @Nullable FT_Stream value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STREAM), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndriver(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRIVER), (long)value);
    }

    public static void nnum_params(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUM_PARAMS), (int)value);
    }

    public static void nparams(long struct, @Nullable FT_Parameter.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARAMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        FT_Open_Args.nnum_params(struct, value == null ? 0 : value.remaining());
    }

    static {
        Struct.Layout layout = FT_Open_Args.__struct((Struct.Member[])new Struct.Member[]{FT_Open_Args.__member((int)4), FT_Open_Args.__member((int)POINTER_SIZE), FT_Open_Args.__member((int)CLONG_SIZE), FT_Open_Args.__member((int)POINTER_SIZE), FT_Open_Args.__member((int)POINTER_SIZE), FT_Open_Args.__member((int)POINTER_SIZE), FT_Open_Args.__member((int)4), FT_Open_Args.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        MEMORY_BASE = layout.offsetof(1);
        MEMORY_SIZE = layout.offsetof(2);
        PATHNAME = layout.offsetof(3);
        STREAM = layout.offsetof(4);
        DRIVER = layout.offsetof(5);
        NUM_PARAMS = layout.offsetof(6);
        PARAMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<FT_Open_Args, Buffer>
    implements NativeResource {
        private static final FT_Open_Args ELEMENT_FACTORY = FT_Open_Args.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FT_Open_Args getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_UInt")
        public int flags() {
            return FT_Open_Args.nflags(this.address());
        }

        @NativeType(value="FT_Byte const *")
        public @Nullable ByteBuffer memory_base() {
            return FT_Open_Args.nmemory_base(this.address());
        }

        @NativeType(value="FT_Long")
        public long memory_size() {
            return FT_Open_Args.nmemory_size(this.address());
        }

        @NativeType(value="FT_String *")
        public @Nullable ByteBuffer pathname() {
            return FT_Open_Args.npathname(this.address());
        }

        @NativeType(value="FT_String *")
        public @Nullable String pathnameString() {
            return FT_Open_Args.npathnameString(this.address());
        }

        public @Nullable FT_Stream stream$() {
            return FT_Open_Args.nstream$(this.address());
        }

        @NativeType(value="FT_Module")
        public long driver() {
            return FT_Open_Args.ndriver(this.address());
        }

        @NativeType(value="FT_Int")
        public int num_params() {
            return FT_Open_Args.nnum_params(this.address());
        }

        @NativeType(value="FT_Parameter *")
        public @Nullable FT_Parameter.Buffer params() {
            return FT_Open_Args.nparams(this.address());
        }

        public Buffer flags(@NativeType(value="FT_UInt") int value) {
            FT_Open_Args.nflags(this.address(), value);
            return this;
        }

        public Buffer memory_base(@NativeType(value="FT_Byte const *") @Nullable ByteBuffer value) {
            FT_Open_Args.nmemory_base(this.address(), value);
            return this;
        }

        public Buffer memory_size(@NativeType(value="FT_Long") long value) {
            FT_Open_Args.nmemory_size(this.address(), value);
            return this;
        }

        public Buffer pathname(@NativeType(value="FT_String *") @Nullable ByteBuffer value) {
            FT_Open_Args.npathname(this.address(), value);
            return this;
        }

        public Buffer stream$(@Nullable FT_Stream value) {
            FT_Open_Args.nstream$(this.address(), value);
            return this;
        }

        public Buffer driver(@NativeType(value="FT_Module") long value) {
            FT_Open_Args.ndriver(this.address(), value);
            return this;
        }

        public Buffer num_params(@NativeType(value="FT_Int") int value) {
            FT_Open_Args.nnum_params(this.address(), value);
            return this;
        }

        public Buffer params(@NativeType(value="FT_Parameter *") @Nullable FT_Parameter.Buffer value) {
            FT_Open_Args.nparams(this.address(), value);
            return this;
        }
    }
}

